<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl leading-tight">Manage</h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
                    <nav class="flex space-x-2">
                        <button wire:click="setTab('dashboard')" class="px-3 py-2 rounded-md text-sm font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $tab==='dashboard' ? 'bg-indigo-50 text-indigo-700 dark:bg-indigo-900/30 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700' }}">Dashboard</button>
                        <button wire:click="setTab('import')" class="px-3 py-2 rounded-md text-sm font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $tab==='import' ? 'bg-indigo-50 text-indigo-700 dark:bg-indigo-900/30 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700' }}">Import Statement</button>
                        <button wire:click="setTab('upload')" class="px-3 py-2 rounded-md text-sm font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $tab==='upload' ? 'bg-indigo-50 text-indigo-700 dark:bg-indigo-900/30 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700' }}">Upload Receipts</button>
                        <button wire:click="setTab('review')" class="px-3 py-2 rounded-md text-sm font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $tab==='review' ? 'bg-indigo-50 text-indigo-700 dark:bg-indigo-900/30 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700' }}">Statement Review</button>
                        <button wire:click="setTab('statements')" class="px-3 py-2 rounded-md text-sm font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $tab==='statements' ? 'bg-indigo-50 text-indigo-700 dark:bg-indigo-900/30 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700' }}">Statements</button>
                    </nav>
                </div>

                <div class="p-6">
                    @if ($tab === 'dashboard')
                        @livewire('manage.dashboard')
                    @elseif ($tab === 'import')
                        @livewire('manage.import-statement')
                    @elseif ($tab === 'upload')
                        @livewire('manage.receipt-bulk-upload')
                    @elseif ($tab === 'review')
                        @livewire('manage.statement-review', ['statementId' => $selectedStatementId], key('review-'.$selectedStatementId))
                    @elseif ($tab === 'statements')
                        @livewire('manage.statements-list', key('statements'))
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>


