# ✅ Stripe Price IDs Now Stored in Database

## What Was Done

Stripe Price IDs are now stored in the **database** instead of environment variables as you requested!

### Changes Made

1. ✅ **Created Migration** - `migrations/004-add-subscription-tiers-table.sql`
   - New `subscription_tiers` table with all pricing configuration
   - Default tiers (Starter, Professional, Business) pre-populated
   
2. ✅ **Updated Database Module** - `src/db-multi-tenant.js`
   - `getAllSubscriptionTiers()` - Fetch all tiers
   - `getSubscriptionTier(tierName)` - Get specific tier
   - `updateSubscriptionTierConfig()` - Update tier config
   - `getTierLimits()` - Get limits with fallback
   
3. ✅ **Updated Stripe Service** - `src/stripe-service.js`
   - Reads Price IDs from database (with 5-min cache)
   - Falls back to env vars if database unavailable
   - All functions updated to use database
   
4. ✅ **Updated Server** - `src/server-multi-tenant.js`
   - Fixed async calls to `isConfigured()`
   - Checkout API uses database tiers
   
5. ✅ **Updated Documentation**
   - `STRIPE-SETUP-NOW.md` - Reflects new database approach
   - `STRIPE-DATABASE-MIGRATION.md` - Complete technical guide
   
6. ✅ **Migration Script** - `run-migration-004.sh`
   - Easy one-command migration

## Next Steps to Enable Stripe

### 1. Run the Migration

```bash
./run-migration-004.sh
```

Or manually:
```bash
psql photowebsite -f migrations/004-add-subscription-tiers-table.sql
```

### 2. Add Your Stripe API Key

In your `.env` file:
```bash
STRIPE_SECRET_KEY=sk_test_your_key_here
```

### 3. Add Stripe Price IDs to Database

**Option A: Quick SQL** (Fastest)

```sql
UPDATE subscription_tiers SET stripe_price_id = 'price_starter' WHERE tier_name = 'starter';
UPDATE subscription_tiers SET stripe_price_id = 'price_professional' WHERE tier_name = 'professional';
UPDATE subscription_tiers SET stripe_price_id = 'price_business' WHERE tier_name = 'business';
```

**Option B: Superuser Interface** (Best for ongoing management)

1. Login as superuser
2. Go to `/superuser/tiers`
3. Edit each tier
4. Add Stripe Price ID
5. Save

### 4. Restart the Server

```bash
npm start
```

### 5. Test!

Try registering with a paid plan at:
```
http://app.localhost:3000/register?plan=professional
```

## Benefits

✨ **No more environment variables for prices**  
✨ **Update prices without redeploying**  
✨ **Manage through superuser interface**  
✨ **Separate config per environment**  
✨ **Automatic caching for performance**  
✨ **Graceful fallback if DB unavailable**  

## Files to Review

- 📄 `STRIPE-DATABASE-MIGRATION.md` - Complete technical documentation
- 📄 `STRIPE-SETUP-NOW.md` - Updated setup guide  
- 📄 `migrations/004-add-subscription-tiers-table.sql` - The migration
- 📄 `run-migration-004.sh` - Migration helper script

## What's in the Database

The `subscription_tiers` table stores:

- **Pricing** - Monthly price, currency
- **Stripe IDs** - Price ID, Product ID  
- **Limits** - Photos, storage, albums, custom domains
- **Trial** - Free trial days
- **Display** - Name, description, order
- **Status** - Active/inactive, featured

All configurable without touching code!

## Example: Viewing Your Tiers

```sql
SELECT 
  tier_name, 
  display_name,
  price_monthly,
  stripe_price_id,
  max_photos
FROM subscription_tiers
ORDER BY display_order;
```

## Example: Updating a Price

```sql
-- Change Professional plan to £30/month
UPDATE subscription_tiers 
SET price_monthly = 3000,
    stripe_price_id = 'price_new_professional_id'
WHERE tier_name = 'professional';
```

Then restart server (or wait 5 min for cache to expire).

## Status

🎉 **Implementation Complete!**

- ✅ Database schema created
- ✅ Database functions added
- ✅ Stripe service updated
- ✅ Server endpoints updated
- ✅ Documentation written
- ✅ Migration script ready

**Just need to:**
1. Run the migration
2. Add your Stripe Price IDs
3. Restart and test!

---

**Questions?** See `STRIPE-DATABASE-MIGRATION.md` for full technical details.

