<div>
<!-- Hero Section -->
<div class="ys-hero text-center">
    <div class="container">
        <h1 class="display-3 fw-bold mb-4">Welcome to Yarn Store</h1>
        <p class="lead mb-4">Premium quality yarns for your creative projects</p>
        <div class="d-flex gap-3 justify-content-center flex-wrap">
            <a href="{{ route('shop.all') }}" class="btn btn-light btn-lg px-5">Shop Now</a>
            <a href="{{ route('about') }}" class="btn btn-outline-light btn-lg px-5">Learn More</a>
        </div>
    </div>
</div>

<!-- Featured Seasons -->
@if($featuredSeasons->count() > 0)
<section class="py-5" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold mb-2">Shop by Season</h2>
            <p class="text-muted">Discover our seasonal yarn collections</p>
        </div>

        <div class="row g-4">
            @foreach($featuredSeasons as $season)
                <div class="col-md-4">
                    <a href="{{ route('shop.season', $season->slug) }}" class="text-decoration-none">
                        <div class="ys-card h-100 overflow-hidden">
                            @if($season->image)
                                <img src="{{ Storage::url($season->image) }}" 
                                     alt="{{ $season->name }}" 
                                     class="w-100" 
                                     style="height: 250px; object-fit: cover;">
                            @else
                                <div class="w-100 d-flex align-items-center justify-content-center" 
                                     style="height: 250px; background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%);">
                                    <h3 class="text-white">{{ $season->name }}</h3>
                                </div>
                            @endif
                            <div class="p-4">
                                <h3 class="h4 fw-bold mb-2" style="color: var(--ys-primary);">{{ $season->name }}</h3>
                                @if($season->description)
                                    <p class="text-muted mb-3">{{ Str::limit($season->description, 100) }}</p>
                                @endif
                                <span class="btn btn-ys-primary">View Collection →</span>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Featured Categories -->
@if($featuredCategories->count() > 0)
<section class="py-5 category-browse-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold mb-2">Browse by Category</h2>
            <p class="text-muted">Find exactly what you're looking for</p>
        </div>

        <div class="row g-4">
            @foreach($featuredCategories as $category)
                <div class="col-lg-2 col-md-4 col-6">
                    <a href="{{ route('shop.category', $category->slug) }}" 
                       class="category-card text-decoration-none">
                        <div class="category-icon-wrapper">
                            <div class="category-icon">
                            </div>
                            <div class="category-icon-glow"></div>
                        </div>
                        <h5 class="category-name">
                            {{ $category->name }}
                        </h5>
                        <div class="category-arrow">→</div>
                    </a>
                </div>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Featured Products -->
@if($featuredProducts->count() > 0)
<section class="py-5" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold mb-2">Latest Arrivals</h2>
            <p class="text-muted">Discover our newest yarns</p>
        </div>

        <div class="product-grid">
            @foreach($featuredProducts as $product)
                <div class="product-card">
                    <a href="{{ route('product.show', $product->slug) }}" class="text-decoration-none">
                        @if($product->primary_image)
                            <img src="{{ Storage::url($product->primary_image) }}" 
                                 alt="{{ $product->name }}"
                                 loading="lazy">
                        @else
                            <div class="d-flex align-items-center justify-content-center bg-secondary text-white" 
                                 style="height: 300px;">
                                <span>No Image</span>
                            </div>
                        @endif
                        
                        <div class="p-3">
                            <div class="d-flex gap-2 mb-2">
                                @if($product->season)
                                    <span class="badge badge-ys-primary small">{{ $product->season->name }}</span>
                                @endif
                                @if($product->category)
                                    <span class="badge badge-ys-accent small">{{ $product->category->name }}</span>
                                @endif
                            </div>
                            
                            <h5 class="fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $product->name }}
                            </h5>
                            
                            @if($product->short_description)
                                <p class="text-muted small mb-2">
                                    {{ Str::limit($product->short_description, 60) }}
                                </p>
                            @endif
                            
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold h5 mb-0" style="color: var(--ys-primary);">
                                    {{ $product->formatted_price }}
                                </span>
                                <span class="btn btn-sm btn-ys-primary">View Details</span>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="text-center mt-5">
            <a href="{{ route('shop.all') }}" class="btn btn-ys-primary btn-lg">
                View All Products
            </a>
        </div>
    </div>
</section>
@endif

<!-- Why Choose Us -->
<section class="py-5">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-3 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--ys-primary);">
                        <path d="M20 7h-9"></path>
                        <path d="M14 17H5"></path>
                        <circle cx="17" cy="17" r="3"></circle>
                        <circle cx="7" cy="7" r="3"></circle>
                    </svg>
                </div>
                <h5 class="fw-bold mb-2">Premium Quality</h5>
                <p class="text-muted small">Hand-selected yarns from the finest suppliers worldwide</p>
            </div>
            
            <div class="col-md-3 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--ys-primary);">
                        <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                        <circle cx="12" cy="10" r="3"></circle>
                    </svg>
                </div>
                <h5 class="fw-bold mb-2">Free UK Delivery</h5>
                <p class="text-muted small">On all orders over £50 with tracked shipping</p>
            </div>
            
            <div class="col-md-3 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--ys-primary);">
                        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                    </svg>
                </div>
                <h5 class="fw-bold mb-2">Secure Shopping</h5>
                <p class="text-muted small">Safe and secure payment processing</p>
            </div>
            
            <div class="col-md-3 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--ys-primary);">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                    </svg>
                </div>
                <h5 class="fw-bold mb-2">Expert Support</h5>
                <p class="text-muted small">Friendly customer service team ready to help</p>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter CTA -->
<section class="py-5" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 text-white mb-4 mb-lg-0">
                <h2 class="fw-bold mb-2">Stay Connected</h2>
                <p class="mb-0">Subscribe to our newsletter for exclusive offers, new arrivals, and crafting inspiration.</p>
            </div>
            <div class="col-lg-6">
                <div class="bg-white p-4 rounded">
                    @livewire('newsletter-signup')
                </div>
            </div>
        </div>
    </div>
</section>
</div>

