<?php

namespace App\Livewire;

use Illuminate\Support\Facades\Validator;
use Livewire\Attributes\Validate;
use Livewire\Component;

class SubscribeNewsletter extends Component
{
    #[Validate('required|string|max:120')]
    public string $name = '';

    #[Validate('required|email')]
    public string $email = '';

    public ?string $status = null;

    public function subscribe(): void
    {
        $this->validate();

        // Here you would dispatch a job or hit a marketing API
        // For now we just set a flash-style status message
        $this->resetErrorBag();
        $this->status = 'Thanks! You\'re on the list.';
        $this->dispatch('newsletter-subscribed');

        // Optional: clear the fields
        $this->name = '';
        $this->email = '';
    }

    public function render()
    {
        return view('livewire.subscribe-newsletter');
    }
}
