<?php

namespace App\Http\Controllers;

use App\Contracts\LibraryService;
use App\Models\Track;
use Illuminate\Http\Request;

class LibraryController extends Controller
{
    public function __construct(private readonly LibraryService $library)
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $tags = $request->string('tags')->toString();
        $tagSlugs = $tags !== '' ? array_filter(array_map('trim', explode(',', $tags))) : null;
        $level = $request->string('level')->toString() ?: null;

        $tracks = $this->library->listTracks($tagSlugs, $level, 24);

        return view('library.index', compact('tracks'));
    }

    public function show(Track $track)
    {
        $audioUrl = $this->library->getSignedAudioUrl($track);
        $imageUrl = $this->library->getSignedImageUrl($track);

        return view('library.show', compact('track', 'audioUrl', 'imageUrl'));
    }
}


