<?php

namespace App\Livewire\Home;

use App\Models\AiContextSummary;
use App\Models\Track;
use Livewire\Component;

class Dashboard extends Component
{
    public function render()
    {
        $latestSummary = AiContextSummary::where('user_id', auth()->id())
            ->orderByDesc('created_at')
            ->first();

        $recentTracks = Track::query()
            ->whereNotNull('published_at')
            ->orderByDesc('published_at')
            ->limit(6)
            ->get();

        return view('livewire.home.dashboard', compact('latestSummary', 'recentTracks'));
    }
}


