<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receipt_statement_matches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('receipt_id')->constrained()->cascadeOnDelete();
            $table->foreignId('statement_line_id')->constrained()->cascadeOnDelete();
            $table->decimal('confidence', 5, 3)->default(0);
            $table->decimal('amount_delta', 12, 2)->default(0);
            $table->integer('date_delta_days')->default(0);
            $table->string('method')->default('heuristic');
            $table->enum('status', ['candidate', 'confirmed', 'rejected'])->default('candidate');
            $table->timestamps();

            $table->unique(['receipt_id', 'statement_line_id']);
            $table->index(['status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipt_statement_matches');
    }
};
