<?php

namespace App\Livewire;

use App\Services\LibraryService;
use Livewire\Component;
use Livewire\WithPagination;
use Livewire\Attributes\Title;

class LibraryPage extends Component
{
    use WithPagination;

    public $search = '';
    public $selectedCategory = '';
    public $selectedDifficulty = '';
    public $selectedVoice = '';

    protected $queryString = [
        'search' => ['except' => ''],
        'selectedCategory' => ['except' => ''],
        'selectedDifficulty' => ['except' => ''],
        'selectedVoice' => ['except' => ''],
    ];

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function updatedSelectedCategory()
    {
        $this->resetPage();
    }

    public function updatedSelectedDifficulty()
    {
        $this->resetPage();
    }

    public function updatedSelectedVoice()
    {
        $this->resetPage();
    }

    public function toggleSort($field)
    {
        if ($this->sortBy === $field) {
            $this->sortOrder = $this->sortOrder === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortBy = $field;
            $this->sortOrder = 'asc';
        }
        $this->resetPage();
    }

    public function clearFilters()
    {
        $this->reset(['search', 'selectedCategory', 'selectedDifficulty', 'selectedVoice']);
        $this->resetPage();
    }

    #[Title('Library - Vybe')]
    public function render()
    {
        $categories = LibraryCategory::where('is_active', true)
            ->orderBy('sort_order')
            ->orderBy('name')
            ->get();

        $query = LibraryTrack::with(['category'])
            ->where('is_active', true);

        // Apply search filter
        if ($this->search) {
            $query->where(function ($q) {
                $q->where('title', 'like', '%' . $this->search . '%')
                  ->orWhere('description', 'like', '%' . $this->search . '%')
                  ->orWhere('tags', 'like', '%' . $this->search . '%');
            });
        }

        // Apply category filter
        if ($this->selectedCategory) {
            $query->where('category_id', $this->selectedCategory);
        }

        // Apply difficulty filter
        if ($this->selectedDifficulty) {
            $query->where('difficulty_level', $this->selectedDifficulty);
        }

        // Apply voice filter
        if ($this->selectedVoice) {
            $query->where('voice_type', $this->selectedVoice);
        }

        // Apply sorting
        $query->orderBy($this->sortBy, $this->sortOrder);

        $tracks = $query->paginate(12);

        return view('livewire.pages.library', [
            'categories' => $categories,
            'tracks' => $tracks,
        ]);
    }
}
