<?php

namespace App\Livewire;

use App\Services\LibraryService;
use Livewire\Component;
use Livewire\WithPagination;
use Livewire\Attributes\Title;

class LibraryPage extends Component
{
    use WithPagination;

    public $search = '';
    public $selectedCategory = '';
    public $selectedDifficulty = '';
    public $selectedVoice = '';
    public $sortBy = 'title';
    public $sortOrder = 'asc';

    protected $queryString = [
        'search' => ['except' => ''],
        'selectedCategory' => ['except' => ''],
        'selectedDifficulty' => ['except' => ''],
        'selectedVoice' => ['except' => ''],
        'sortBy' => ['except' => 'title'],
        'sortOrder' => ['except' => 'asc'],
    ];

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function updatedSelectedCategory()
    {
        $this->resetPage();
    }

    public function updatedSelectedDifficulty()
    {
        $this->resetPage();
    }

    public function updatedSelectedVoice()
    {
        $this->resetPage();
    }

    public function clearFilters()
    {
        $this->reset(['search', 'selectedCategory', 'selectedDifficulty', 'selectedVoice']);
        $this->resetPage();
    }

    public function toggleSort($field)
    {
        if ($this->sortBy === $field) {
            $this->sortOrder = $this->sortOrder === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortBy = $field;
            $this->sortOrder = 'asc';
        }
        $this->resetPage();
    }

    #[Title('Library - Vybe')]
    public function render()
    {
        $libraryService = app(LibraryService::class);
        
        $categories = $libraryService->getCategories();
        
        $tracks = $libraryService->getTracks(
            $this->selectedCategory ?: null,
            $this->selectedVoice ?: null,
            $this->selectedDifficulty ?: null,
            $this->search ?: null,
            12,
            $this->sortBy,
            $this->sortOrder
        );

        return view('livewire.pages.library', [
            'categories' => $categories,
            'tracks' => $tracks,
            'sortBy' => $this->sortBy,
            'sortOrder' => $this->sortOrder,
        ]);
    }
}
