<?php
$meta = [
  'title' => 'Small Business IT Support Newcastle',
  'description' => 'Friendly, reliable IT help — email, backups, Wi‑Fi, security, and same‑day support in Newcastle.',
  'canonical' => 'https://neilwiddowson.co.uk/services/it-support.php'
];
$currentPage = 'services';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Friendly, reliable IT help — without the jargon.</h1>
    <p class="mt-4 text-gray-700">Stop losing time to IT problems. I fix computers, networks, and security issues quickly — with clear explanations you can understand.</p>
    
    <div class="mt-8 grid gap-8 lg:grid-cols-2">
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">What I fix</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Email setup, passwords, and account issues</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Wi-Fi, internet, and network problems</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Computer upgrades and performance issues</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Backups, security, and virus protection</span>
          </li>
        </ul>
      </div>
      
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Why choose me?</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Same-day remote help when available</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Plain English explanations, no jargon</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Fixed pricing, no surprise charges</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Bitdefender reseller for business & home security</span>
          </li>
        </ul>
      </div>
    </div>

    <div class="mt-12">
      <h2 class="text-2xl font-bold text-gray-900 mb-6">IT Support Pricing</h2>
      <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        <div class="pricing-card">
          <h3 class="text-lg font-semibold text-gray-900">Quick remote help</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£60 / hr</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>1‑hour minimum, same‑day if available</li>
            <li>Email, backups, Wi‑Fi, printers</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Book a slot</a></div>
        </div>
        <div class="pricing-card pricing-featured">
          <h3 class="text-lg font-semibold text-gray-900">Support block</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£220 / 4 hrs</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Use across a month</li>
            <li>Remote or on‑site mix</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get started</a></div>
        </div>
        <div class="pricing-card">
          <h3 class="text-lg font-semibold text-gray-900">On‑site call‑out</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£50 + £60 / hr</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Within 20 miles of Killingworth</li>
            <li>Networks, hardware, installations</li>
            <li>Minimum 1 hour charge applies</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Book on-site visit</a></div>
        </div>
      </div>
    </div>

    <div class="mt-12 text-center">
      <h2 class="text-xl font-semibold text-gray-900 mb-4">Need help right now?</h2>
      <p class="text-gray-600 mb-6">Call for same-day support or book a slot that works for you.</p>
      <div class="flex flex-col sm:flex-row gap-3 justify-center">
        <a class="btn-primary" href="/contact/">Get a free quote</a>
        <a class="btn-secondary" href="tel:+440000000000">Call now</a>
      </div>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
