<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

// Frontend Routes
Route::get('/', [App\Http\Controllers\FrontendController::class, 'home'])->name('home');
Route::get('/collections', [App\Http\Controllers\FrontendController::class, 'collections'])->name('collections');
Route::get('/collections/{slug}', [App\Http\Controllers\FrontendController::class, 'collectionsBySeason'])->name('collections.season');
Route::get('/category/{slug}', [App\Http\Controllers\FrontendController::class, 'category'])->name('category');
Route::get('/product/{slug}', [App\Http\Controllers\FrontendController::class, 'product'])->name('product');
Route::get('/search', [App\Http\Controllers\FrontendController::class, 'search'])->name('search');
Route::get('/basket', App\Livewire\Basket::class)->name('basket');

// Documentation Pages
Route::get('/about', [App\Http\Controllers\FrontendController::class, 'about'])->name('about');
Route::get('/care-guide', [App\Http\Controllers\FrontendController::class, 'careGuide'])->name('care-guide');
Route::get('/patterns', [App\Http\Controllers\FrontendController::class, 'patterns'])->name('patterns');
Route::get('/contact', [App\Http\Controllers\FrontendController::class, 'contact'])->name('contact');

// Legal Pages
Route::get('/terms', [App\Http\Controllers\FrontendController::class, 'terms'])->name('terms');
Route::get('/privacy', [App\Http\Controllers\FrontendController::class, 'privacy'])->name('privacy');
Route::get('/cookies', [App\Http\Controllers\FrontendController::class, 'cookies'])->name('cookies');

// Customer Account Routes
// Route::middleware('auth')->prefix('account')->name('account.')->group(function () {
//     Route::get('/profile', App\Livewire\Account\Profile::class)->name('profile');
//     Route::get('/orders', App\Livewire\Account\Orders::class)->name('orders');
//     Route::get('/orders/{orderId}', App\Livewire\Account\OrderDetail::class)->name('orders.show');
//     Route::get('/addresses', App\Livewire\Account\Addresses::class)->name('addresses');
// });

Auth::routes();

// Apply middleware to authentication routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [App\Http\Controllers\Auth\LoginController::class, 'login']);
    Route::get('/register', [App\Http\Controllers\Auth\RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [App\Http\Controllers\Auth\RegisterController::class, 'register']);
});

Route::middleware('auth')->group(function () {
    Route::post('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
});

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])
    ->middleware('auth')
    ->name('home.authenticated');

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', App\Livewire\Admin\Dashboard::class)->name('dashboard');
    Route::get('/orders', App\Livewire\Admin\Orders::class)->name('orders');
    Route::get('/orders/{orderId}', App\Livewire\Admin\OrderDetail::class)->name('orders.show');
    Route::get('/customers', App\Livewire\Admin\Customers::class)->name('customers');
    Route::get('/customers/{customerId}', App\Livewire\Admin\CustomerDetail::class)->name('customers.show');
    
    Route::get('/seasons', App\Livewire\Admin\Seasons::class)->name('seasons');
    Route::get('/seasons/{seasonId}', App\Livewire\Admin\SeasonDetail::class)->name('seasons.show');
    Route::get('/categories', App\Livewire\Admin\Categories::class)->name('categories');
    Route::get('/categories/{categoryId}', App\Livewire\Admin\CategoryDetail::class)->name('categories.show');
    Route::get('/items', App\Livewire\Admin\Items::class)->name('items');
    Route::get('/items/{itemId}', App\Livewire\Admin\ItemDetail::class)->name('items.show');
});
