<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    return view('welcome');
})->name('home');

Auth::routes();

// Apply middleware to authentication routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [App\Http\Controllers\Auth\LoginController::class, 'login']);
    Route::get('/register', [App\Http\Controllers\Auth\RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [App\Http\Controllers\Auth\RegisterController::class, 'register']);
});

Route::middleware('auth')->group(function () {
    Route::post('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
});

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])
    ->middleware('auth')
    ->name('home.authenticated');

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', App\Livewire\Admin\Dashboard::class)->name('dashboard');
    Route::get('/orders', App\Livewire\Admin\Orders::class)->name('orders');
    Route::get('/customers', App\Livewire\Admin\Customers::class)->name('customers');
    Route::get('/customers/{customerId}', App\Livewire\Admin\CustomerDetail::class)->name('customers.show');
    
    Route::get('/seasons', App\Livewire\Admin\Seasons::class)->name('seasons');
    Route::get('/categories', App\Livewire\Admin\Categories::class)->name('categories');
    Route::get('/items', App\Livewire\Admin\Items::class)->name('items');
});
