<?php

use Illuminate\Support\Facades\Route;

// ============================================
// FRONT-END ROUTES (Customer-Facing)
// ============================================

// Home Page
Route::get('/', App\Livewire\HomePage::class)->name('home');

// TEMPORARY TEST ROUTE
Route::get('/test-products', function () {
    return view('test-products');
});

// Shop Routes
Route::get('/shop', App\Livewire\ShopAll::class)->name('shop.all');
Route::get('/shop/season/{seasonSlug}', App\Livewire\ShopSeason::class)->name('shop.season');
Route::get('/shop/category/{categorySlug}', App\Livewire\ShopCategory::class)->name('shop.category');
Route::get('/shop/search', App\Livewire\ShopAll::class)->name('shop.search');
Route::get('/product/{slug}', App\Livewire\ProductDetail::class)->name('product.show');

// Basket & Checkout
Route::get('/basket', App\Livewire\Basket::class)->name('basket');
Route::get('/checkout', function () {
    return view('pages.checkout');
})->name('checkout');

// Customer Account Routes (Protected)
Route::middleware('auth')->prefix('account')->name('account.')->group(function () {
    Route::get('/dashboard', App\Livewire\Account\Dashboard::class)->name('dashboard');
    Route::get('/orders', App\Livewire\Account\Orders::class)->name('orders');
    Route::get('/orders/{orderId}', function () {
        return view('pages.account.order-detail');
    })->name('order');
    Route::get('/profile', App\Livewire\Account\Profile::class)->name('profile');
    Route::get('/addresses', function () {
        return view('pages.account.addresses');
    })->name('addresses');
});

// Contact
Route::get('/contact', App\Livewire\ContactPage::class)->name('contact');

// About & Info Pages
Route::get('/about', function () {
    return view('pages.about');
})->name('about');

Route::get('/faq', function () {
    return view('pages.faq');
})->name('faq');

// Guide Pages
Route::get('/guides/care', function () {
    return view('pages.guides.care');
})->name('guides.care');

Route::get('/guides/choosing', function () {
    return view('pages.guides.choosing');
})->name('guides.choosing');

Route::get('/guides/patterns', function () {
    return view('pages.guides.patterns');
})->name('guides.patterns');

// Legal Pages
Route::get('/terms', function () {
    return view('pages.terms');
})->name('terms');

Route::get('/privacy', function () {
    return view('pages.privacy');
})->name('privacy');

Route::get('/cookies', function () {
    return view('pages.cookies');
})->name('cookies');

Route::get('/gdpr', function () {
    return view('pages.gdpr');
})->name('gdpr');

Route::get('/shipping', function () {
    return view('pages.shipping');
})->name('shipping');

Route::get('/returns', function () {
    return view('pages.returns');
})->name('returns');

// ============================================
// AUTHENTICATION ROUTES
// ============================================

// Apply middleware to authentication routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [App\Http\Controllers\Auth\LoginController::class, 'login']);
    Route::get('/register', [App\Http\Controllers\Auth\RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [App\Http\Controllers\Auth\RegisterController::class, 'register']);
});

Route::middleware('auth')->group(function () {
    Route::post('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
});

// ============================================
// ADMIN ROUTES (Backend)
// ============================================

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', App\Livewire\Admin\Dashboard::class)->name('dashboard');
    Route::get('/orders', App\Livewire\Admin\Orders::class)->name('orders');
    Route::get('/orders/{orderId}', App\Livewire\Admin\OrderDetail::class)->name('orders.show');
    Route::get('/customers', App\Livewire\Admin\Customers::class)->name('customers');
    Route::get('/customers/{customerId}', App\Livewire\Admin\CustomerDetail::class)->name('customers.show');
    
    Route::get('/seasons', App\Livewire\Admin\Seasons::class)->name('seasons');
    Route::get('/seasons/{seasonId}', App\Livewire\Admin\SeasonDetail::class)->name('seasons.show');
    Route::get('/categories', App\Livewire\Admin\Categories::class)->name('categories');
    Route::get('/categories/{categoryId}', App\Livewire\Admin\CategoryDetail::class)->name('categories.show');
    Route::get('/items', App\Livewire\Admin\Items::class)->name('items');
    Route::get('/items/{itemId}', App\Livewire\Admin\ItemDetail::class)->name('items.show');
});
