<?php

use Illuminate\Support\Facades\Route;

// Public routes
Route::get('/', function () {
    return view('pages.home');
})->name('home');

Route::get('/library', function () {
    return view('pages.library.index');
})->name('library.index');

Route::get('/library/{track}', function ($track) {
    return view('pages.library.show', compact('track'));
})->name('library.show');

// Auth routes (handled by Breeze)
require __DIR__.'/auth.php';

// Authenticated routes
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return view('pages.dashboard');
    })->name('dashboard');

    Route::get('/profile', function () {
        return view('pages.profile');
    })->name('profile');

    Route::get('/custom', function () {
        return view('pages.custom.request');
    })->middleware('consents.accepted')->name('custom.request');

    Route::get('/custom/sessions', function () {
        return view('pages.custom.sessions');
    })->middleware('consents.accepted')->name('custom.sessions.index');

    Route::get('/custom/sessions/{id}', function ($id) {
        return view('pages.custom.show', compact('id'));
    })->middleware('consents.accepted')->name('custom.sessions.show');

    Route::get('/account', function () {
        return view('pages.account');
    })->name('account');

    Route::get('/entitlements', function () {
        return view('pages.entitlements');
    })->name('entitlements');
});

// Admin routes
Route::middleware(['auth', 'can:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', function () {
        return view('pages.admin.dashboard');
    })->name('dashboard');

    Route::get('/library/tracks', function () {
        return view('pages.dashboard');
    })->name('library.tracks');

    Route::get('/safety', function () {
        return view('pages.admin.safety');
    })->name('safety');
});
