<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SessionController;
use App\Http\Controllers\MeditationController;
use App\Http\Controllers\ApiDocumentationController;
use App\Http\Controllers\ProfileController;
use App\Livewire\Sessions\SessionList;
use App\Livewire\Sessions\SessionCreate;
use App\Livewire\Sessions\SessionShow;
use App\Livewire\Meditations\MeditationList;
use App\Livewire\Meditations\MeditationCreate;
use App\Livewire\Meditations\MeditationShow;
use App\Livewire\Analytics\AnalyticsDashboard;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [HomeController::class, 'index'])->name('home');

// API Documentation
Route::get('/api-docs', [ApiDocumentationController::class, 'index'])->name('api.documentation');

// Authentication routes (handled by Laravel Breeze if installed)
Route::middleware('guest')->group(function () {
    Route::get('/login', function () {
        return view('auth.login');
    })->name('login');
    
    Route::get('/register', function () {
        return view('auth.register');
    })->name('register');
});

Route::middleware('auth')->group(function () {
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Sessions
    Route::prefix('sessions')->name('sessions.')->group(function () {
        Route::get('/', SessionList::class)->name('index');
        Route::get('/create', SessionCreate::class)->name('create');
        Route::get('/{session}', SessionShow::class)->name('show');
    });
    
    // Meditations
    Route::prefix('meditations')->name('meditations.')->group(function () {
        Route::get('/', MeditationList::class)->name('index');
        Route::get('/create', MeditationCreate::class)->name('create');
        Route::get('/{meditation}', MeditationShow::class)->name('show');
    });
    
    // Analytics Dashboard
    Route::get('/analytics', AnalyticsDashboard::class)->name('analytics');
});

// Logout
Route::post('/logout', function () {
    auth()->logout();
    return redirect('/');
})->name('logout');
