#!/bin/bash

# Run migration 008: Home Page Customization System
echo "Running migration 008: Home Page Customization System..."

# Get database connection string from environment or use default
if [ -z "$DATABASE_URL" ]; then
    echo "Error: DATABASE_URL environment variable is not set"
    echo "Please set it with: export DATABASE_URL='postgresql://username:password@localhost:5432/vybephoto'"
    exit 1
fi

# Run the migration
psql "$DATABASE_URL" -f migrations/008-add-home-customization.sql

if [ $? -eq 0 ]; then
    echo "✅ Migration 008 completed successfully!"
else
    echo "❌ Migration 008 failed!"
    exit 1
fi

