const fs = require('fs');
const db = require('./src/db-multi-tenant');

async function runMigration() {
  try {
    console.log('=========================================');
    console.log('Creating Promotional Offers System');
    console.log('=========================================\n');
    
    const migrationSQL = fs.readFileSync('migrations/007-add-promotional-offers.sql', 'utf8');
    
    await db.pool.query(migrationSQL);
    
    console.log('✅ Migration completed successfully!\n');
    console.log('New tables created:');
    console.log('  - promotional_offers: Store offer configurations');
    console.log('  - offer_redemptions: Track who redeemed which offers\n');
    console.log('Sample offers created:');
    console.log('  - WELCOME30: 30-day trial extension');
    console.log('  - PRO50OFF: 50% off Professional for 3 months\n');
    
    process.exit(0);
  } catch (error) {
    console.error('❌ Error running migration:', error.message);
    process.exit(1);
  }
}

runMigration();

