<div class="space-y-6">
    <div class="flex flex-col sm:flex-row items-start sm:items-center gap-3">
        <input type="text" placeholder="Search tracks..." class="input input-bordered w-full sm:max-w-md"
               wire:model.debounce.500ms="search" />

        <select class="select select-bordered" wire:model="level">
            <option value="">All levels</option>
            <option value="beginner">Beginner</option>
            <option value="intermediate">Intermediate</option>
            <option value="advanced">Advanced</option>
        </select>
    </div>

    <div class="flex flex-wrap gap-2">
        @foreach ($allTags as $tag)
            <button type="button"
                    class="badge py-3 px-4 cursor-pointer {{ in_array($tag->id, $selectedTagIds ?? []) ? 'badge-primary' : 'badge-outline' }}"
                    wire:click="$toggle('selectedTagIds', {{ $tag->id }})">
                {{ $tag->name }}
            </button>
        @endforeach
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach ($tracks as $track)
            <a href="{{ route('library.show', ['track' => $track->id]) }}" class="block rounded-lg border p-4 hover:shadow">
                <div class="text-sm text-gray-500">{{ ucfirst($track->level) }}</div>
                <div class="font-semibold">{{ $track->title }}</div>
                <div class="text-sm line-clamp-2 text-gray-600">{{ $track->description }}</div>
                <div class="text-xs mt-2">{{ $track->duration_sec }} sec</div>
            </a>
        @endforeach
    </div>

    <div>
        {{ $tracks->links() }}
    </div>
</div>


