#!/bin/bash

# Load environment variables from .env file
if [ -f .env ]; then
  export $(cat .env | grep -v '^#' | xargs)
fi

DB_NAME=${DB_NAME:-photowebsite}
DB_USER=${DB_USER:-postgres}
DB_HOST=${DB_HOST:-localhost}
DB_PORT=${DB_PORT:-5432}

MIGRATION_FILE="migrations/006-add-payment-enforcement-override.sql"

echo "========================================="
echo "Adding Payment Enforcement Override"
echo "========================================="
echo "Database: $DB_NAME"
echo "Host: $DB_HOST"
echo "Port: $DB_PORT"
echo "User: $DB_USER"
echo ""

# Check if psql is available
if ! command -v psql &> /dev/null
then
    echo "Error: psql command not found. Please ensure PostgreSQL client is installed and in your PATH."
    exit 1
fi

# Execute the migration
PGPASSWORD=$DB_PASSWORD psql -h $DB_HOST -p $DB_PORT -U $DB_USER -d $DB_NAME -f $MIGRATION_FILE

if [ $? -eq 0 ]; then
    echo ""
    echo "✅ Migration completed successfully!"
    echo ""
    echo "New columns added:"
    echo "  - skip_payment_enforcement: Admin override to skip payment checks"
    echo "  - last_payment_check_at: Timestamp of last payment check"
    echo "  - payment_grace_period_ends: When grace period expires"
else
    echo ""
    echo "❌ Error applying migration $MIGRATION_FILE."
    exit 1
fi

