const fs = require('fs');
const db = require('./src/db-multi-tenant');

async function runMigration() {
  try {
    console.log('=========================================');
    console.log('Adding Payment Enforcement Override');
    console.log('=========================================\n');
    
    const migrationSQL = fs.readFileSync('migrations/006-add-payment-enforcement-override.sql', 'utf8');
    
    await db.pool.query(migrationSQL);
    
    console.log('✅ Migration completed successfully!\n');
    console.log('New columns added:');
    console.log('  - skip_payment_enforcement: Admin override to skip payment checks');
    console.log('  - last_payment_check_at: Timestamp of last payment check');
    console.log('  - payment_grace_period_ends: When grace period expires\n');
    
    process.exit(0);
  } catch (error) {
    console.error('❌ Error running migration:', error.message);
    process.exit(1);
  }
}

runMigration();

