const fs = require('fs');
const db = require('./src/db-multi-tenant');

async function runMigration() {
  try {
    console.log('=========================================');
    console.log('Adding Stripe columns to subscription_tiers table');
    console.log('=========================================\n');
    
    // Read the migration file
    const migrationSQL = fs.readFileSync('./migrations/005-add-stripe-columns-to-tiers.sql', 'utf8');
    
    // Execute the migration
    console.log('Executing migration...\n');
    await db.pool.query(migrationSQL);
    
    console.log('✅ Migration completed successfully!\n');
    
    // Verify the new columns were added
    console.log('Verifying new columns...\n');
    const result = await db.pool.query(`
      SELECT column_name, data_type, is_nullable
      FROM information_schema.columns 
      WHERE table_name = 'subscription_tiers' 
      AND column_name IN ('stripe_price_id', 'stripe_product_id', 'currency', 'trial_days', 'is_featured', 'max_albums', 'custom_domain_enabled')
      ORDER BY column_name;
    `);
    
    console.log('Columns added/verified:');
    result.rows.forEach(col => {
      console.log(`  ✓ ${col.column_name}: ${col.data_type} (nullable: ${col.is_nullable})`);
    });
    
    console.log('\n✅ All done! You can now save Stripe Price IDs through the superuser interface.');
    
    await db.pool.end();
    process.exit(0);
  } catch (error) {
    console.error('❌ Migration failed:', error.message);
    console.error(error);
    process.exit(1);
  }
}

runMigration();

