<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class StandardUserSeeder extends Seeder
{
    public function run(): void
    {
        $email = 'user@example.com';
        $password = 'password';

        $user = User::firstOrCreate(
            ['email' => $email],
            [
                'name' => 'Standard User',
                'password' => Hash::make($password),
            ]
        );

        if (!$user->hasRole('user')) {
            $user->assignRole('user');
        }
    }
}


