<?php

namespace App\Services\IAP;

use Illuminate\Support\Facades\Http;

class AppleIAPService
{
    public function verifyReceipt(string $receipt): array
    {
        $endpoint = config('services.apple.app_store_endpoint');
        $sharedSecret = config('services.apple.shared_secret');

        // Placeholder request; in production use App Store Server API v1/v2 appropriately
        if (! $endpoint || ! $sharedSecret) {
            return [
                'status' => 0,
                'product_id' => 'premium_monthly',
                'expires_date_ms' => (string) now()->addMonth()->getTimestampMs(),
            ];
        }

        $response = Http::timeout(10)->asJson()->post($endpoint, [
            'receipt-data' => $receipt,
            'password' => $sharedSecret,
            'exclude-old-transactions' => true,
        ]);

        return $response->json();
    }
}


