<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Receipt extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'statement_id',
        'matched_transaction_id',
        'receipt_date',
        'total_amount',
        'currency',
        'vendor_name',
        'is_personal',
        'storage_path',
        'department',
        'account_code',
        'vat_total',
        'vat_analysis',
        'status',
    ];

    protected $casts = [
        'receipt_date' => 'date',
        'total_amount' => 'decimal:2',
        'is_personal' => 'boolean',
        'vat_total' => 'decimal:2',
        'vat_analysis' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(ReceiptItem::class);
    }
}


