<div class="space-y-8">
    <div>
        <h2 class="text-xl font-semibold">Welcome back</h2>
        @if ($latestSummary)
            <div class="mt-3 rounded border p-4 bg-gray-50">
                <div class="text-sm text-gray-500">Summary ({{ optional($latestSummary->created_at)->diffForHumans() }})</div>
                <div class="mt-1 whitespace-pre-line">{{ $latestSummary->summary }}</div>
            </div>
        @else
            <div class="mt-3 text-gray-500">No summaries yet.</div>
        @endif
    </div>

    <div>
        <h3 class="text-lg font-semibold">Recent tracks</h3>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mt-3">
            @foreach ($recentTracks as $track)
                <a href="{{ route('library.show', ['track' => $track->id]) }}" class="block rounded-lg border p-4 hover:shadow">
                    <div class="text-sm text-gray-500">{{ ucfirst($track->level) }}</div>
                    <div class="font-semibold">{{ $track->title }}</div>
                    <div class="text-sm line-clamp-2 text-gray-600">{{ $track->description }}</div>
                </a>
            @endforeach
        </div>
    </div>

    <div class="flex gap-3">
        <a class="btn" href="{{ route('library.index') }}">Browse library</a>
        <a class="btn" href="{{ route('profile.edit') }}">Edit profile</a>
    </div>
</div>


