<?php

namespace App\Models;

use Illuminate\Support\Facades\Cache;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BaseModel extends Model
{
    use HasFactory;
    protected static function booted()
       {
           static::created(function ($model) {
               $model->clearCache();
           });

           static::updated(function ($model) {
               $model->clearCache();
           });

           static::deleted(function ($model) {
               $model->clearCache();
           });
       }

    public function scopeAllCached($query, $cacheDuration = 3600)
     {
         $cacheKey = 'all_' . get_class($this);
         return Cache::remember($cacheKey, $cacheDuration, function () use ($query) {
             return $query->get();
         });
     }

     protected function clearCache()
     {
         $cacheKey = 'all_' . get_class($this);

         // Check if the cache entry exists before forgetting it
         if (Cache::has($cacheKey)) {
             Cache::forget($cacheKey);
         }
     }

}
