require('dotenv').config();
const db = require('./src/db-multi-tenant');

async function checkSuperuser() {
  try {
    const result = await db.pool.query(
      'SELECT id, username, email, is_superuser FROM users WHERE is_superuser = true LIMIT 5'
    );
    
    if (result.rows.length === 0) {
      console.log('\n❌ No superuser accounts found!\n');
      console.log('Create one with: node setup-superuser-node.js\n');
    } else {
      console.log('\n✅ Superuser accounts found:\n');
      result.rows.forEach(user => {
        console.log(`   Username: ${user.username}`);
        console.log(`   Email: ${user.email}`);
        console.log(`   ID: ${user.id}`);
        console.log('');
      });
      console.log('You can log in at: http://app.localhost:3000/login\n');
    }
    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error.message);
    process.exit(1);
  }
}

checkSuperuser();


