<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'order_number',
        'status',
        'initial_subtotal',
        'initial_tax_amount',
        'initial_shipping_amount',
        'initial_total_amount',
        'invoiced_subtotal',
        'invoiced_tax_amount',
        'invoiced_shipping_amount',
        'invoiced_total_amount',
        'currency',
        'zoho_invoice_number',
        'supplier_invoice_number',
        'notes',
        'shipped_at',
        'delivered_at',
        'tracking_number',
    ];

    protected function casts(): array
    {
        return [
            'initial_subtotal' => 'decimal:2',
            'initial_tax_amount' => 'decimal:2',
            'initial_shipping_amount' => 'decimal:2',
            'initial_total_amount' => 'decimal:2',
            'invoiced_subtotal' => 'decimal:2',
            'invoiced_tax_amount' => 'decimal:2',
            'invoiced_shipping_amount' => 'decimal:2',
            'invoiced_total_amount' => 'decimal:2',
            'shipped_at' => 'datetime',
            'delivered_at' => 'datetime',
        ];
    }

    /**
     * Get the user that owns the order
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the order lines for the order
     */
    public function orderLines(): HasMany
    {
        return $this->hasMany(OrderLine::class);
    }
}

