@extends('layouts.frontend')

@section('meta_title', ($category->meta_title ?? $category->name) . ' - Yarn Store')
@section('meta_description', $category->meta_description ?? $category->description)

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <a href="{{ route('collections') }}">Collections</a>
                <span>/</span>
                <span>{{ $category->name }}</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-8 mx-auto text-center">
            <h1 class="display-4 fw-bold mb-3">{{ $category->name }}</h1>
            @if($category->description)
                <p class="lead text-muted">{{ $category->description }}</p>
            @endif
        </div>
    </div>

    @if($products->count() > 0)
        <div class="product-grid">
            @foreach($products as $product)
                <a href="{{ route('product', $product->slug) }}" class="text-decoration-none">
                    <div class="product-card">
                        @if($product->primary_image)
                            <img src="{{ Storage::url($product->primary_image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="product-image"
                                 loading="lazy">
                        @else
                            <div class="product-image d-flex align-items-center justify-content-center" 
                                 style="background-color: var(--ys-bg-tertiary);">
                                <span class="text-muted">No image</span>
                            </div>
                        @endif
                        <div class="product-info">
                            <h3 class="h6 fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $product->name }}
                            </h3>
                            <p class="text-muted small mb-2">
                                {{ $product->season->name }}
                            </p>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold" style="color: var(--ys-primary);">
                                    {{ $product->formatted_price }}
                                </span>
                                @if($product->colourways->count() > 0)
                                    <span class="text-muted small">
                                        {{ $product->colourways->count() }} {{ Str::plural('colour', $product->colourways->count()) }}
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </a>
            @endforeach
        </div>

        <div class="d-flex justify-content-center mt-5">
            {{ $products->links() }}
        </div>
    @else
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="ys-card p-5 text-center">
                    <p class="text-muted mb-0">No products available in this category yet.</p>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

