<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Custom Session Requests') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-medium">Pending Custom Session Requests</h3>
                        <div class="text-sm text-gray-500">
                            {{ $requests->count() }} pending requests
                        </div>
                    </div>

                    @if($requests->isEmpty())
                        <div class="text-center py-12">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No pending requests</h3>
                            <p class="mt-1 text-sm text-gray-500">All custom session requests have been processed.</p>
                        </div>
                    @else
                        <div class="space-y-6">
                            @foreach($requests as $request)
                                <div class="border border-gray-200 rounded-lg p-6 hover:shadow-md transition-shadow">
                                    <div class="flex justify-between items-start mb-4">
                                        <div>
                                            <h4 class="text-lg font-medium text-gray-900">{{ $request->topic }}</h4>
                                            <p class="text-sm text-gray-500">Requested by {{ $request->user->name }} ({{ $request->user->email }})</p>
                                        </div>
                                        <div class="flex items-center space-x-2">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                {{ Str::title($request->status) }}
                                            </span>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                {{ $request->session_length }}
                                            </span>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <p class="text-gray-700">{{ $request->description }}</p>
                                    </div>

                                    <div class="grid grid-cols-2 gap-4 mb-4 text-sm">
                                        <div>
                                            <span class="font-medium text-gray-700">Voice Preference:</span>
                                            <span class="text-gray-600 ml-2">{{ Str::title($request->voice_preference) }}</span>
                                        </div>
                                        <div>
                                            <span class="font-medium text-gray-700">Requested:</span>
                                            <span class="text-gray-600 ml-2">{{ $request->created_at->format('M j, Y g:i A') }}</span>
                                        </div>
                                    </div>

                                    @if($request->special_notes)
                                        <div class="mb-4 p-3 bg-gray-50 rounded-md">
                                            <span class="font-medium text-gray-700">Special Notes:</span>
                                            <p class="text-gray-600 mt-1">{{ $request->special_notes }}</p>
                                        </div>
                                    @endif

                                    <div class="flex justify-end space-x-3">
                                        <button onclick="rejectRequest({{ $request->id }})" class="px-4 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-md hover:bg-red-200">
                                            Reject
                                        </button>
                                        <button onclick="approveRequest({{ $request->id }})" class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-md hover:bg-green-700">
                                            Approve
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Request Modal -->
    <div id="rejectModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Reject Request</h3>
                <form id="rejectForm" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label for="reason" class="block text-sm font-medium text-gray-700 mb-2">Reason for Rejection</label>
                        <textarea id="reason" name="reason" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-red-500" required></textarea>
                    </div>
                    <div class="flex justify-end space-x-3">
                        <button type="button" onclick="closeRejectModal()" class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-red-600 rounded-md hover:bg-red-700">
                            Reject
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function approveRequest(requestId) {
            if (confirm('Are you sure you want to approve this request? This will create a custom session.')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = `/admin/custom-requests/${requestId}/approve`;
                
                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = '{{ csrf_token() }}';
                
                form.appendChild(csrfToken);
                document.body.appendChild(form);
                form.submit();
            }
        }

        function rejectRequest(requestId) {
            document.getElementById('rejectForm').action = `/admin/custom-requests/${requestId}/reject`;
            document.getElementById('rejectModal').classList.remove('hidden');
        }

        function closeRejectModal() {
            document.getElementById('rejectModal').classList.add('hidden');
        }
    </script>
</x-app-layout>
