<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_lines', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('order_id')->constrained()->cascadeOnDelete();
            $table->foreignId('item_id')->constrained()->restrictOnDelete();
            $table->foreignId('colourway_id')->nullable()->constrained()->restrictOnDelete();
            $table->integer('quantity')->default(1);
            $table->integer('estimated_weight_g')->nullable();
            $table->integer('final_weight_g')->nullable();
            $table->bigInteger('price_estimated_minor')->default(0);
            $table->bigInteger('price_final_minor')->default(0);
            $table->string('factory_po', 50)->nullable();
            $table->jsonb('attributes')->nullable();
            $table->timestamps();

            // Indexes
            $table->index('order_id');
            $table->index(['item_id', 'colourway_id']);
        });

        // PostgreSQL CHECK constraints (only for PostgreSQL)
        if (DB::connection()->getDriverName() === 'pgsql') {
            DB::statement("ALTER TABLE order_lines ADD CONSTRAINT check_quantity CHECK (quantity > 0)");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_lines');
    }
};
