<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureConsentsAccepted
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();
        
        if (!$user) {
            return redirect()->route('login');
        }

        // Check if user has accepted required consents
        $requiredConsents = ['tos', 'privacy'];
        $acceptedConsents = $user->consents()->pluck('type')->toArray();
        
        foreach ($requiredConsents as $consent) {
            if (!in_array($consent, $acceptedConsents)) {
                return redirect()->route('account')->with('error', 'Please accept required consents before accessing custom sessions.');
            }
        }

        return $next($request);
    }
}
