<?php

namespace App\Services;

use App\Contracts\MediaUrlService as MediaUrlServiceContract;
use Illuminate\Support\Facades\Storage;

class MediaUrlServiceImpl implements MediaUrlServiceContract
{
    public function signed(string $path, ?string $disk = null, ?int $ttlSeconds = null): string
    {
        $diskName = $disk ?? config('filesystems.media_disk', env('MEDIA_DISK', config('filesystems.default')));
        $ttl = $ttlSeconds ?? (int) env('SIGNED_URL_TTL', 300);

        $diskInstance = Storage::disk($diskName);

        // Try temporaryUrl if available and disk supports it
        if (method_exists($diskInstance, 'temporaryUrl')) {
            try {
                return $diskInstance->temporaryUrl($path, now()->addSeconds($ttl));
            } catch (\Throwable $e) {
                // Fallback to url()
            }
        }

        return $diskInstance->url($path);
    }
}


