@extends('layouts.frontend')

@section('meta_title', 'About Yarn Types & Materials - Yarn Store')
@section('meta_description', 'Learn about different types of yarn, from wool and cotton to mohair and silk. Discover which yarn is best for your next knitting or crochet project.')
@section('meta_keywords', 'yarn types, wool yarn, cotton yarn, knitting yarn, crochet yarn, yarn materials, merino wool, alpaca, mohair, silk yarn')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>About Yarn</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-8 mx-auto text-center">
            <h1 class="display-4 fw-bold mb-3">Understanding Yarn Types & Materials</h1>
            <p class="lead text-muted">
                A comprehensive guide to help you choose the perfect yarn for your next project
            </p>
        </div>
    </div>

    <!-- Introduction -->
    <div class="row mb-5">
        <div class="col-lg-10 mx-auto">
            <div class="ys-card p-4">
                <p class="text-muted">
                    Choosing the right yarn is essential for any knitting or crochet project. Different fibers have unique 
                    properties that affect the look, feel, warmth, and durability of your finished piece. This guide will 
                    help you understand the characteristics of various yarn types and make informed decisions for your projects.
                </p>
            </div>
        </div>
    </div>

    <!-- Yarn Types -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Natural Fibers</h2>
        </div>

        <!-- Wool -->
        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Wool</h3>
                <p class="text-muted mb-3">
                    Wool is the most popular yarn fiber, prized for its warmth, elasticity, and versatility. 
                    It comes from sheep and is available in various qualities.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Excellent insulation and warmth</li>
                    <li>Natural elasticity - springs back to shape</li>
                    <li>Moisture-wicking properties</li>
                    <li>Naturally flame-resistant</li>
                    <li>Can be scratchy depending on quality</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Sweaters, hats, scarves, blankets, socks, winter accessories
                </p>
            </div>
        </div>

        <!-- Merino Wool -->
        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Merino Wool</h3>
                <p class="text-muted mb-3">
                    A premium type of wool from Merino sheep, known for its exceptional softness and fine fibers.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Ultra-soft and comfortable against skin</li>
                    <li>Finer fibers than regular wool</li>
                    <li>Excellent temperature regulation</li>
                    <li>Less prone to pilling</li>
                    <li>Higher price point</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Baby items, next-to-skin garments, luxury sweaters, shawls
                </p>
            </div>
        </div>

        <!-- Cotton -->
        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Cotton</h3>
                <p class="text-muted mb-3">
                    A plant-based fiber that's cool, breathable, and perfect for warmer weather projects.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Breathable and cool to wear</li>
                    <li>Strong and durable</li>
                    <li>Machine washable and easy care</li>
                    <li>No elasticity - can stretch over time</li>
                    <li>Hypoallergenic</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Summer tops, dishcloths, baby items, blankets, market bags
                </p>
            </div>
        </div>

        <!-- Alpaca -->
        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Alpaca</h3>
                <p class="text-muted mb-3">
                    A luxury fiber from alpacas, known for exceptional warmth and softness.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Warmer than wool</li>
                    <li>Incredibly soft and silky</li>
                    <li>Hypoallergenic (no lanolin)</li>
                    <li>Limited elasticity</li>
                    <li>Luxury price point</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Luxury sweaters, wraps, scarves, special occasion garments
                </p>
            </div>
        </div>

        <!-- Mohair -->
        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Mohair</h3>
                <p class="text-muted mb-3">
                    From Angora goats, mohair creates a distinctive fuzzy halo effect.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Lightweight but warm</li>
                    <li>Lustrous sheen</li>
                    <li>Creates a fuzzy halo</li>
                    <li>Durable and resilient</li>
                    <li>Often blended with other fibers</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Textured sweaters, shawls, accent pieces, lightweight garments
                </p>
            </div>
        </div>

        <!-- Silk -->
        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Silk</h3>
                <p class="text-muted mb-3">
                    A natural protein fiber with beautiful drape and luxurious sheen.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Exceptional drape</li>
                    <li>Lustrous and smooth</li>
                    <li>Strong and durable</li>
                    <li>Temperature regulating</li>
                    <li>Requires careful washing</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Luxury shawls, evening wear, blended with other fibers for added drape
                </p>
            </div>
        </div>
    </div>

    <!-- Synthetic Fibers -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Synthetic & Blended Fibers</h2>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Acrylic</h3>
                <p class="text-muted mb-3">
                    A synthetic fiber that mimics wool at a lower price point.
                </p>
                <h4 class="h6 fw-semibold mb-2">Characteristics:</h4>
                <ul class="text-muted small mb-3">
                    <li>Affordable and widely available</li>
                    <li>Easy care - machine washable</li>
                    <li>Doesn't felt or shrink</li>
                    <li>Less breathable than natural fibers</li>
                    <li>Good color retention</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Practice projects, children's items, blankets, budget-friendly projects
                </p>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Blended Yarns</h3>
                <p class="text-muted mb-3">
                    Combining different fibers creates yarns with the best properties of each.
                </p>
                <h4 class="h6 fw-semibold mb-2">Popular Blends:</h4>
                <ul class="text-muted small mb-3">
                    <li>Wool/Acrylic - warmth with easy care</li>
                    <li>Cotton/Bamboo - softness and breathability</li>
                    <li>Wool/Silk - warmth with drape and sheen</li>
                    <li>Alpaca/Silk - luxury with structure</li>
                </ul>
                <h4 class="h6 fw-semibold mb-2">Best for:</h4>
                <p class="text-muted small mb-0">
                    Versatile projects where you want multiple fiber benefits
                </p>
            </div>
        </div>
    </div>

    <!-- Yarn Weight Guide -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Understanding Yarn Weights</h2>
        </div>
        <div class="col-12">
            <div class="ys-card p-4">
                <p class="text-muted mb-4">
                    Yarn weight refers to the thickness of the yarn strand and affects how quickly your project works up 
                    and the final look. Here's a quick guide:
                </p>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Weight Category</th>
                                <th>Also Known As</th>
                                <th>Recommended Needle Size</th>
                                <th>Typical Use</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>0 - Lace</td>
                                <td>Lace, Thread</td>
                                <td>1.5-2.25mm</td>
                                <td>Lace shawls, doilies</td>
                            </tr>
                            <tr>
                                <td>1 - Super Fine</td>
                                <td>Sock, Fingering, Baby</td>
                                <td>2.25-3.25mm</td>
                                <td>Socks, baby items</td>
                            </tr>
                            <tr>
                                <td>2 - Fine</td>
                                <td>Sport, Baby</td>
                                <td>3.25-3.75mm</td>
                                <td>Light sweaters, baby items</td>
                            </tr>
                            <tr>
                                <td>3 - Light</td>
                                <td>DK, Light Worsted</td>
                                <td>3.75-4.5mm</td>
                                <td>Light sweaters, accessories</td>
                            </tr>
                            <tr>
                                <td>4 - Medium</td>
                                <td>Worsted, Afghan, Aran</td>
                                <td>4.5-5.5mm</td>
                                <td>Sweaters, blankets, most projects</td>
                            </tr>
                            <tr>
                                <td>5 - Bulky</td>
                                <td>Chunky, Craft, Rug</td>
                                <td>5.5-8mm</td>
                                <td>Quick projects, hats, scarves</td>
                            </tr>
                            <tr>
                                <td>6 - Super Bulky</td>
                                <td>Super Chunky, Roving</td>
                                <td>8mm+</td>
                                <td>Very quick projects, rugs</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA -->
    <div class="row">
        <div class="col-lg-8 mx-auto text-center">
            <div class="ys-card p-5" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-dark) 100%);">
                <h2 class="h3 fw-bold mb-3 text-white">Ready to Start Your Project?</h2>
                <p class="text-white mb-4">
                    Explore our curated collections of premium yarns in various materials and weights.
                </p>
                <a href="{{ route('collections') }}" class="btn btn-light btn-lg">
                    Browse Our Collections
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

