<?php
$meta = [
  'title' => 'AI Workflow Automation & Reporting | Case Study',
  'description' => 'Introduced AI-assisted workflows for estimation and reporting, cutting manual effort and errors.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/ai-automation-reporting.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">AI Workflow Automation & Reporting</h1>
    <p class="mt-2 text-sm text-gray-600">Lead Software Developer — manufacturing sector</p>

    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Problem</h2>
        <p class="mt-2 text-sm text-gray-700">Routine estimation and reporting tasks consumed hours weekly and were prone to errors.</p>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">What I built</h2>
        <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
          <li>AI LLM assistants embedded in internal tools to draft estimates and documentation.</li>
          <li>Automated SQL reports visualised in lightweight dashboards.</li>
          <li>Background jobs and webhooks for hands‑off updates.</li>
        </ul>
      </div>
    </div>

    <div class="card p-4 mt-6">
      <h2 class="font-semibold text-gray-900">Outcome</h2>
      <p class="mt-2 text-sm text-gray-700">Hours saved each week and clearer visibility of live data; reduced manual entry and fewer mistakes.</p>
    </div>

    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>


