<?php

return [
    'project' => env('VERTEX_PROJECT', env('GOOGLE_CLOUD_PROJECT')),
    // Revert to previously working default region
    'location' => env('VERTEX_LOCATION', 'europe-west2'),
    // Optional: Use API key auth for Vertex AI (Gemini on Vertex). If not set, OAuth ADC will be used.
    'api_key' => env('VERTEX_API_KEY'),
        'models' => [
            // Use 2.5-flash-lite as used by OCR previously
            'match' => env('VERTEX_MODEL_MATCH', 'gemini-2.5-flash-lite'),
            'classify' => env('VERTEX_MODEL_CLASSIFY', 'gemini-2.5-flash-lite'),
            'vat' => env('VERTEX_MODEL_VAT', 'gemini-2.5-flash-lite'),
            'ocr' => env('VERTEX_MODEL_OCR', 'gemini-2.5-flash-lite'),
            'analyze' => env('VERTEX_MODEL_ANALYZE', 'gemini-2.5-flash-lite'),
        ],
    'temperature' => (float) env('VERTEX_TEMPERATURE', 0.2),
    'top_p' => (float) env('VERTEX_TOP_P', 0.95),
    'top_k' => (int) env('VERTEX_TOP_K', 40),
];


