<?php

return [
    'project' => env('VERTEX_PROJECT', env('GOOGLE_CLOUD_PROJECT')),
    'location' => env('VERTEX_LOCATION', 'europe-west2'),
    // Optional: Use API key auth for Vertex AI (Gemini on Vertex). If not set, OAuth ADC will be used.
    'api_key' => env('VERTEX_API_KEY'),
    'models' => [
        'match' => env('VERTEX_MODEL_MATCH', 'gemini-1.5-flash'),
        'classify' => env('VERTEX_MODEL_CLASSIFY', 'gemini-1.5-flash'),
        'vat' => env('VERTEX_MODEL_VAT', 'gemini-1.5-flash'),
        'ocr' => env('VERTEX_MODEL_OCR', 'gemini-2.5-flash-lite'),
    ],
    'temperature' => (float) env('VERTEX_TEMPERATURE', 0.2),
    'top_p' => (float) env('VERTEX_TOP_P', 0.95),
    'top_k' => (int) env('VERTEX_TOP_K', 40),
];


