<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Price;
use App\Models\Design;
use App\Models\Samples;
use App\Helper\Functions;
use App\Helper\Conversions;
use App\Models\ShipmentLine;
use App\Models\StyleVersions;
use Livewire\Attributes\Rule;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;
use App\Models\CustomerOrderLineQuantities;

class PricingSheetForm extends Form
{
	public $styles;

	public function clear(){
		$this->reset();
	}

	public function set($styles){
		$this->styles = $styles;
	}

	public function update($val, $var)
	{
		// dd($val, $var);
		$p = explode('.', $var)[1];
		$var = explode('.', $var)[2];


		switch($var){
			case 'style_version_name':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required|string|max:35'],
				)->validate();
				$styleVersion = StyleVersions::find($this->styles[$p]['style_version_id']);
				$styleVersion->update(['name' => $val]);
				break;
			case 'factory_id':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$styleVersion = StyleVersions::find($this->styles[$p]['style_version_id']);
				$styleVersion->update(['factory_id' => $val]);
				break;
			case 'price_name':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['name' => $val]);
				break;
			case 'model':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['model' => $val]);
				break;
			case 'sizes_id':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['sizes_id' => empty($val) ? NULL : $val]);
				break;
			case 'colourways_id':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'nullable'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['colourways_id' => empty($val) ? NULL : $val]);
				break;
			case 'colour_type':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['colour_type' => empty($val) ? NULL : $val]);
				break;
			case 'yarnkg_currency':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['yarn_currency' => $val]);
				break;
			case 'yarnkg':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['yarn' => $val]);
				break;
			case 'yarn_trans_currency':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['yarn_trans_currency' => $val]);
				break;
			case 'yarn_trans':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['yarn_trans' => $val]);
				break;
			case 'weight':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['weight' => $val, 'costed_weight' => $val * 1.10]);
				break;
			case 'costed_weight':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['costed_weight' => $val]);
				break;
			case 'cmt':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required|numeric|max:500'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['cmt' => $val]);
				break;
			case 'cmt_status':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['cmt_status' => $val]);
				break;
			case 'valid_until':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['valid_until' => $val]);
				break;
			case 'aoc':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['aoc' => $val]);
				break;
			case 'accessory_currency':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['accessory_currency' => $val]);
				break;
			case 'accessory':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['accessory' => $val]);
				break;
			case 'label_currency':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['label_currency' => $val]);
				break;
			case 'label':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['label' => $val]);
				break;
			case 'gmt_trans_currency':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['gmt_trans_currency' => $val]);
				break;
			case 'gmt_trans':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['gmt_trans' => $val]);
				break;
			case 'testing':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['testing' => $val]);
				break;
			case 'testing_courier':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['testing_courier' => $val]);
				break;
			case 'embroidery_currency':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['embroidery_currency' => $val]);
				break;
			case 'embroidery':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['embroidery' => $val]);
				break;
            case 'duty':
                Validator::make(
                    ['var' => $this->styles[$p][$var]],
                    ['var' => 'required'],
                )->validate();
                $price = Price::find($this->styles[$p]['price_id']);
                $price->update(['duty' => $val]);
                break;
			case 'quote':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['quote' => $val]);
				break;
			case 'quote_status':
                // dd($val);
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);

                if($val == "confirmed"){
                    $otherConfirmed = Price::where('style_versions_id', $price->style_versions_id)
                        ->where('quote_status', 'confirmed')
                        ->where('colourways_id', $price->colourways_id)
                        ->where('colour_type', $price->colour_type)
                        ->where('sizes_id', $price->sizes_id)
                        ->get();
                    if($otherConfirmed->count() != 0){
                        session()->flash('message', 'Error. Can\'t have several identical confirmed prices.');
                        session()->flash('alert-class', 'alert-warning');
                    }
					else{
						$price->update(['quote_status' => $val]);
					}
                }
                else{
                    $price->update(['quote_status' => $val]);
                }
				break;
			case 'target':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['target' => $val]);
				break;
			case 'min_qty':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'required'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['min_qty' => $val]);
				break;
			case 'notes':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'nullable'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['notes' => $val]);
				break;
			case 'customer_notes':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'nullable'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['customer_notes' => $val]);
				break;
			case 'weight_comments':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'nullable'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['weight_comments' => $val]);
				break;
			case 'cost_comments':
				Validator::make(
					['var' => $this->styles[$p][$var]],
					['var' => 'nullable'],
				)->validate();
				$price = Price::find($this->styles[$p]['price_id']);
				$price->update(['cost_comments' => $val]);
				break;
		}

        $colq = CustomerOrderLineQuantities::
            with('customer_order_lines.colourways.style_versions.styles.seasons', 'customer_order_lines.colourways.style_versions.prices')->
            whereRelation('customer_order_lines.colourways', 'style_versions_id', $this->styles[$p]['style_version_id'])->
            get();
        // dd($colq->pluck('id'), $this->styles[$p]['style_version_id']);

        foreach($colq as $line){
            $price = Functions::getPrice(
                $line->customer_order_lines->colourways->style_versions->prices,
                $line->sizes_id,
                $line->customer_order_lines->colourways->colour_type,
                $line->customer_order_lines->colourways->id
            );

            // dd($price, $line->sizes_id, $line->customer_order_lines->colourways->style_versions->prices);

            if(!is_string($price)){
                // dd($price);
                $line->update([
                    'prices_id' => $price->id,
                    // Price resolution system will handle caching automatically
                    // No need to set old cache columns
                ]);
            }
        }


        // if(gate::check('asdasd')){
        //     $colq = CustomerOrderLineQuantities::where('id', 82456)->
        //     with('customer_order_lines.colourways.style_versions.styles.seasons', 'customer_order_lines.colourways.style_versions.prices')->
        //     get();

        //     dd($colq);

        //     $errors = [];
        //     foreach($colq as $line){
        //         if(empty($line->customer_order_lines->colourways)){
        //             $errors[] = $line->id;
        //         }
        //         else{
        //             $price = Functions::getPrice(
        //                 $line->customer_order_lines->colourways->style_versions->prices,
        //                 $line->sizes_id,
        //                 $line->customer_order_lines->colourways->colour_type,
        //                 $line->customer_order_lines->colourways->id
        //             );

        //             if(!is_string($price)){
        //                 // dd($price);
        //                 $line->update([
        //                     'prices_id' => $price->id,

        //                     'quote_cache' => $price->quote,
        //                     'cmt_cache' => $price->cmt,
        //                     'cost_cache' => number_format($price->cost, 2),


        //                     'transport_budget_cache' => number_format(Conversions::convertCurrency($price->gmt_trans_currency ?? '€', '£', $price->gmt_trans, $line->customer_order_lines->colourways->style_versions->styles->seasons),2),
        //                     'quote_status_cache' => $price->quote_status,
        //                     'cmt_status_cache' => $price->cmt_status,
        //                 ]);
        //             }
        //         }
        //     }
        //     dd($errors);

        // }

	}
}
