<form wire:submit="subscribe" class="newsletter-form">
    @if ($status)
        <div class="alert alert-success d-flex align-items-center border-0 bg-success bg-opacity-10 text-success" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i>
            <div>{{ $status }}</div>
        </div>
    @endif
    
    <div class="row g-3">
        <div class="col-md-4">
            <label for="newsletter-name" class="form-label text-light opacity-90">Name</label>
            <input id="newsletter-name" type="text" class="form-control form-control-lg bg-transparent border-light text-white" 
                   wire:model.live="name" placeholder="Your name" 
                   style="border-color: rgba(255,255,255,0.3);">
            @error('name')
                <div class="text-warning small mt-1">{{ $message }}</div>
            @enderror
        </div>
        <div class="col-md-4">
            <label for="newsletter-email" class="form-label text-light opacity-90">Email</label>
            <input id="newsletter-email" type="email" class="form-control form-control-lg bg-transparent border-light text-white" 
                   wire:model.live="email" placeholder="you@example.com"
                   style="border-color: rgba(255,255,255,0.3);">
            @error('email')
                <div class="text-warning small mt-1">{{ $message }}</div>
            @enderror
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-light btn-lg w-100 text-dark fw-semibold">
                <i class="bi bi-send me-2"></i> Subscribe
            </button>
        </div>
    </div>
    
    <div class="text-center mt-3">
        <small class="text-light opacity-75">Join our community of textile enthusiasts</small>
    </div>
</form>

<style>
.newsletter-form .form-control::placeholder {
    color: rgba(255,255,255,0.6);
}

.newsletter-form .form-control:focus {
    background-color: rgba(255,255,255,0.1) !important;
    border-color: rgba(255,255,255,0.6) !important;
    box-shadow: 0 0 0 0.25rem rgba(255,255,255,0.1);
}

.newsletter-form .btn-light:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255,255,255,0.3);
}
</style>
