<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Library') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <!-- Filters -->
                    <div class="mb-6">
                        <div class="flex flex-col sm:flex-row gap-4">
                            <div class="flex-1">
                                <label for="search" class="block text-sm font-medium text-gray-700">Search</label>
                                <input type="text" id="search" name="search" placeholder="Search tracks..." 
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            <div class="w-full sm:w-48">
                                <label for="category" class="block text-sm font-medium text-gray-700">Category</label>
                                <select id="category" name="category" 
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="">All Categories</option>
                                    <option value="sleep">Sleep</option>
                                    <option value="stress">Stress</option>
                                    <option value="confidence">Confidence</option>
                                    <option value="focus">Focus</option>
                                </select>
                            </div>
                            <div class="w-full sm:w-48">
                                <label for="duration" class="block text-sm font-medium text-gray-700">Duration</label>
                                <select id="duration" name="duration" 
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="">Any Duration</option>
                                    <option value="0-10">0-10 minutes</option>
                                    <option value="10-20">10-20 minutes</option>
                                    <option value="20+">20+ minutes</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Tracks Grid -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <!-- Demo Track 1 -->
                        <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow">
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-indigo-100 text-indigo-800">
                                        Sleep
                                    </span>
                                    <span class="text-sm text-gray-500">15 min</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">Deep Sleep Induction</h3>
                                <p class="text-gray-600 text-sm mb-4">A gentle journey into deep, restorative sleep with calming imagery and progressive relaxation.</p>
                                <div class="flex items-center justify-between">
                                    <div class="flex space-x-2">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">relaxation</span>
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">sleep</span>
                                    </div>
                                    <a href="{{ route('library.show', 1) }}" 
                                       class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">
                                        Listen
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Demo Track 2 -->
                        <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow">
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        Stress
                                    </span>
                                    <span class="text-sm text-gray-500">20 min</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">Stress Relief & Calm</h3>
                                <p class="text-gray-600 text-sm mb-4">Release tension and find inner peace through guided breathing and mindfulness techniques.</p>
                                <div class="flex items-center justify-between">
                                    <div class="flex space-x-2">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">mindfulness</span>
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">breathing</span>
                                    </div>
                                    <a href="{{ route('library.show', 2) }}" 
                                       class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">
                                        Listen
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Demo Track 3 -->
                        <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow">
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                        Confidence
                                    </span>
                                    <span class="text-sm text-gray-500">18 min</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">Unshakeable Confidence</h3>
                                <p class="text-gray-600 text-sm mb-4">Build lasting self-confidence and overcome self-doubt with powerful affirmations and visualization.</p>
                                <div class="flex items-center justify-between">
                                    <div class="flex space-x-2">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">confidence</span>
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-800">self-esteem</span>
                                    </div>
                                    <a href="{{ route('library.show', 3) }}" 
                                       class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">
                                        Listen
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Empty State (hidden by default) -->
                    <div class="hidden text-center py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3" />
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No tracks found</h3>
                        <p class="mt-1 text-sm text-gray-500">Try adjusting your search or filter criteria.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
