<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Contracts\LibraryService as LibraryServiceContract;
use App\Services\LibraryServiceImpl;
use App\Contracts\ProfileService as ProfileServiceContract;
use App\Services\ProfileServiceImpl;
use App\Contracts\MemoryService as MemoryServiceContract;
use App\Services\MemoryServiceImpl;
use App\Contracts\SafetyService as SafetyServiceContract;
use App\Services\SafetyServiceImpl;
use App\Contracts\PlaybackService as PlaybackServiceContract;
use App\Services\PlaybackServiceImpl;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
		$this->app->bind(LibraryServiceContract::class, LibraryServiceImpl::class);
		$this->app->bind(ProfileServiceContract::class, ProfileServiceImpl::class);
		$this->app->bind(MemoryServiceContract::class, MemoryServiceImpl::class);
		$this->app->bind(SafetyServiceContract::class, SafetyServiceImpl::class);
		$this->app->bind(PlaybackServiceContract::class, PlaybackServiceImpl::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
