<?php
$meta = [
  'title' => 'QA Dashboards & Kerberos Research | Case Study',
  'description' => 'Built live QA dashboards and investigated Kerberos across multi-site environments.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/qa-dashboards-kerberos.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">QA Dashboards & Kerberos Research</h1>
    <p class="mt-2 text-sm text-gray-600">Software Placement — Prismtech</p>

    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">What I did</h2>
        <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
          <li>Researched and presented dashboard tooling for automated test data.</li>
          <li>Investigated Kerberos for staff devices across multiple sites.</li>
          <li>Worked in an Agile team using standups and Jira.</li>
        </ul>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Outcome</h2>
        <p class="mt-2 text-sm text-gray-700">Improved visibility into test health and informed decisions around authentication strategy.</p>
      </div>
    </div>

    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>


