<div>
    @if (session('status'))
        <div class="mb-4 text-green-600">{{ session('status') }}</div>
    @endif

    <form wire:submit.prevent="import" class="space-y-4">
        <div>
            <label class="block text-sm font-medium">Cardholder Name</label>
            <input type="text" wire:model.defer="cardholder_name" class="mt-1 w-full border rounded px-3 py-2" required>
        </div>
        <div>
            <label class="block text-sm font-medium">Account Number (masked)</label>
            <input type="text" wire:model.defer="account_number_masked" class="mt-1 w-full border rounded px-3 py-2" placeholder="****5318" required>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Period Start</label>
                <input type="date" wire:model.defer="period_start" class="mt-1 w-full border rounded px-3 py-2" required>
            </div>
            <div>
                <label class="block text-sm font-medium">Period End</label>
                <input type="date" wire:model.defer="period_end" class="mt-1 w-full border rounded px-3 py-2" required>
            </div>
        </div>
        <div>
            <label class="block text-sm font-medium">Statement File (xlsx, xls, csv)</label>
            <input type="file" wire:model="file" class="mt-1 w-full" accept=".xlsx,.xls,.csv" required>
        </div>
        <div>
            <x-primary-button type="submit" wire:loading.attr="disabled">Import Statement</x-primary-button>
            <span wire:loading class="ml-2 text-sm">Importing...</span>
        </div>
        @error('file') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </form>
</div>
