<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.items') }}" class="text-decoration-none">Items</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $item->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Item Details</h1>
            <p class="text-muted mb-0">View and manage item information, specifications, and colourways</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Item
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Two-column layout: Left 1/3 Colourways, Right 2/3 Item Details -->
    <div class="row">
        <!-- Left: Colourways (1/3) -->
        <div class="col-lg-4 order-2 order-lg-2">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="bi bi-palette me-2"></i>Colourways
                    </h6>
                </div>
                <div class="card-body">
                    @if($editing)
                        <div class="mb-3">
                            <div class="mb-3">
                                <label class="form-label small">Import Colour Codes (PDF)</label>
                                <input type="file" wire:model="colourwayPdf" class="form-control form-control-sm @error('colourwayPdf') is-invalid @enderror" accept="application/pdf">
                                @error('colourwayPdf') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                <button type="button" wire:click="processColourwayPdf" class="btn btn-outline-primary btn-sm mt-2">
                                    <i class="bi bi-filetype-pdf me-1"></i> Process PDF
                                </button>
                            </div>
                            
                            <label class="form-label small">Add New Colourway</label>
                            <div class="input-group input-group-sm mb-2">
                                <input type="text"
                                       wire:model="newColourwayReference"
                                       class="form-control @error('newColourwayReference') is-invalid @enderror"
                                       placeholder="Colourway Reference">
                                <button wire:click="addColourway" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Add
                                </button>
                            </div>
                            @error('newColourwayReference') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            <small class="text-muted">Add the reference, then click on the colourway card to paste an image</small>
                        </div>
                    @endif

                    @if($item->colourways->count() > 0)
                        <div class="row g-3">
                            @foreach($item->colourways as $colourway)
                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="border rounded p-2 h-100 d-flex flex-column"
                                         @if($editing)
                                         x-data="colourwayCardUpload({{ $colourway->id }})"
                                         @click="setFocused"
                                         @focus="setFocused"
                                         @blur="removeFocused"
                                         @paste="handlePaste($event)"
                                         @dragover.prevent="handleDragOver($event)"
                                         @dragleave.prevent="handleDragLeave($event)"
                                         @drop.prevent="handleDrop($event)"
                                         :class="{ 'border-primary border-2': isFocused, 'bg-light': isDragging }"
                                         style="cursor: pointer;"
                                         tabindex="0"
                                         @endif>
                                        <div class="text-center mb-2 position-relative">
                                            @if($colourway->image)
                                                <img src="{{ asset('storage/' . $colourway->image) }}" 
                                                     alt="{{ $colourway->reference }}" 
                                                     class="img-fluid rounded"
                                                     style="height: 130px; object-fit: cover; width: 100%;">
                                            @else
                                                <div class="text-center py-4 bg-light rounded">
                                                    <i class="bi bi-image text-muted fs-2"></i>
                                                    <div class="small text-muted mt-2">No image</div>
                                                </div>
                                            @endif
                                            @if($editing)
                                                <div class="position-absolute top-0 end-0 p-1">
                                                    <div class="badge bg-secondary" x-show="isFocused" style="font-size: 0.7rem;">
                                                        <i class="bi bi-clipboard"></i> Paste here
                                                    </div>
                                                </div>
                                                <input type="file" 
                                                       wire:model="colourwayImages.{{ $colourway->id }}" 
                                                       accept="image/*" 
                                                       class="d-none" 
                                                       x-ref="fileInput"
                                                       @change="onFileChanged">
                                            @endif
                                        </div>

                                        <div class="d-flex align-items-center justify-content-between">
                                            @if($editing)
                                                <input type="text"
                                                       value="{{ $colourway->reference }}"
                                                       wire:blur="updateColourway({{ $colourway->id }}, 'reference', $event.target.value)"
                                                       class="form-control form-control-sm me-2"
                                                       placeholder="Reference"
                                                       @click.stop>
                                                <button wire:click="removeColourway({{ $colourway->id }})"
                                                        class="btn btn-outline-danger btn-sm"
                                                        style="width: 28px; height: 28px; padding: 0;"
                                                        onclick="return confirm('Delete this colourway?')"
                                                        @click.stop>
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            @else
                                                <div class="text-center w-100">
                                                    <code class="small">{{ $colourway->reference }}</code>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-3">
                            <i class="bi bi-palette fs-1 text-muted"></i>
                            <p class="text-muted small mb-0">No colourways added yet</p>
                            @if($editing)
                                <p class="text-muted small">Add colourways using the form above</p>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right: Item Details (2/3) -->
        <div class="col-lg-8 order-1 order-lg-1">
            <!-- Overview -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-tag text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Item Name</label>
                            </div>
                            @if($editing)
                                <input type="text" wire:model="name" class="form-control form-control-sm @error('name') is-invalid @enderror">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fw-medium">{{ $item->name }}</div>
                            @endif
                        </div>
                        
                        <div class="col-md-3">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-currency-dollar text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Price</label>
                            </div>
                            @if($editing)
                                <input type="number" wire:model="price" class="form-control form-control-sm @error('price') is-invalid @enderror" step="0.01" min="0">
                                @error('price') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fw-medium text-primary">{{ $item->formatted_price }}</div>
                            @endif
                    </div>

                        <div class="col-md-3">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-upc text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">SKU</label>
                                </div>
                                @if($editing)
                                <input type="text" wire:model="sku" class="form-control form-control-sm @error('sku') is-invalid @enderror">
                                @error('sku') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <code class="small">{{ $item->sku ?: 'No SKU' }}</code>
                                @endif
                    </div>

                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-tags text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Category</label>
                                </div>
                                @if($editing)
                                <select wire:model="categoriesId" class="form-select form-select-sm @error('categoriesId') is-invalid @enderror">
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('categoriesId') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <span class="badge bg-secondary">{{ $item->category->name }}</span>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar3 text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Season</label>
                                </div>
                                @if($editing)
                                <select wire:model="seasonsId" class="form-select form-select-sm @error('seasonsId') is-invalid @enderror">
                                        <option value="">Select Season</option>
                                        @foreach($seasons as $season)
                                            <option value="{{ $season->id }}">{{ $season->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('seasonsId') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <span class="badge bg-info">{{ $item->season->name }}</span>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-gear text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Status</label>
                            </div>
                            @if($editing)
                                <div class="form-check form-switch">
                                    <input type="checkbox" wire:model="isActive" class="form-check-input" id="isActive">
                                    <label class="form-check-label small" for="isActive">Active</label>
                                </div>
                            @else
                                @if($item->is_active)
                                    <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Active</span>
                                @else
                                    <span class="badge bg-secondary"><i class="bi bi-pause-circle me-1"></i>Inactive</span>
                                @endif
                            @endif
                    </div>

                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-file-text text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Short Description</label>
                                </div>
                                @if($editing)
                                <input type="text" wire:model="shortDescription" class="form-control form-control-sm @error('shortDescription') is-invalid @enderror" placeholder="Brief description...">
                                @error('shortDescription') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <div class="small text-muted">{{ $item->short_description ?: 'No short description' }}</div>
                                @endif
                            </div>
                            
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-link-45deg text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">URL Slug</label>
                                </div>
                                @if($editing)
                                <input type="text" wire:model="slug" class="form-control form-control-sm @error('slug') is-invalid @enderror">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <code class="small">{{ $item->slug }}</code>
                                @endif
                    </div>
                </div>
            </div>
        </div>

            <!-- Full Description -->
            @if($item->description || $editing)
            <div class="card mb-4">
                <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="bi bi-file-text me-2"></i>Full Description
                        </h6>
                </div>
                <div class="card-body">
                        @if($editing)
                            <textarea wire:model="description" class="form-control @error('description') is-invalid @enderror" rows="3" placeholder="Detailed item description..."></textarea>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                        @else
                            <div class="text-body">{{ $item->description ?: 'No description provided' }}</div>
                                        @endif
                                    </div>
                                </div>
            @endif

            <!-- Specifications -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="bi bi-list-ul me-2"></i>Specifications
                    </h6>
                </div>
                <div class="card-body">
                    @if($editing)
                        <div class="row g-2 mb-3">
                            <div class="col-md-4">
                                <input type="text" wire:model="newSpecName" class="form-control form-control-sm" placeholder="Spec name (e.g., Material)">
                            </div>
                            <div class="col-md-6">
                                <input type="text" wire:model="newSpecValue" class="form-control form-control-sm" placeholder="Value (e.g., 100% Cotton)">
                            </div>
                            <div class="col-md-2">
                                <button wire:click="addSpecification" class="btn btn-primary btn-sm w-100">
                                    <i class="bi bi-plus"></i> Add
                                </button>
                            </div>
                        </div>
                    @endif

                    @if(is_array($specifications) && count($specifications) > 0)
                        <div class="row g-2">
                    @foreach($specifications as $index => $spec)
                                @if(is_array($spec) && isset($spec['name']) && isset($spec['value']))
                        <div class="col-md-6">
                                        <div class="border rounded p-2">
                                            @if($editing)
                                                <div class="row g-1">
                                                    <div class="col-5">
                                                        <input type="text" wire:model="specifications.{{ $index }}.name" class="form-control form-control-sm">
                                                    </div>
                                                    <div class="col-5">
                                                        <input type="text" wire:model="specifications.{{ $index }}.value" class="form-control form-control-sm">
                                                    </div>
                                                    <div class="col-2">
                                                        <button wire:click="removeSpecification({{ $index }})" class="btn btn-outline-danger btn-sm w-100">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-semibold small">{{ $spec['name'] }}</div>
                                                        <div class="text-muted" style="font-size: 0.8rem;">{{ $spec['value'] }}</div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                                        </div>
                                                    @endif
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="text-center py-3">
                            <i class="bi bi-list-ul fs-1 text-muted"></i>
                            <p class="text-muted small mb-0">No specifications added yet</p>
                        </div>
                    @endif
                </div>
                </div>
        </div>
    </div>
</div>


@push('scripts')
<script>

/**
 * Alpine.js component for handling paste directly on colourway cards
 * Each colourway card can accept paste/drop to update its image
 */
function colourwayCardUpload(colourwayId) {
    return {
        colourwayId: colourwayId,
        isFocused: false,
        isDragging: false,

        setFocused() {
            this.isFocused = true;
            console.log('Colourway card focused:', this.colourwayId);
        },

        removeFocused() {
            setTimeout(() => {
                this.isFocused = false;
            }, 100);
        },

        handleDragOver(event) {
            this.isDragging = true;
        },

        handleDragLeave(event) {
            if (!event.currentTarget.contains(event.relatedTarget)) {
                this.isDragging = false;
            }
        },

        async handleDrop(event) {
            this.isDragging = false;
            console.log('Drop on colourway:', this.colourwayId);
            
            try {
                if (event.dataTransfer.files && event.dataTransfer.files.length > 0) {
                    await this.handleFiles(event.dataTransfer.files);
                    return;
                }
                
                const html = event.dataTransfer.getData('text/html');
                const text = event.dataTransfer.getData('text/plain');
                
                if (html) {
                    const imgMatch = html.match(/<img[^>]+src="([^">]+)"/);
                    if (imgMatch && imgMatch[1]) {
                        await this.loadImageFromUrl(imgMatch[1]);
                        return;
                    }
                }
                
                if (text && (text.startsWith('http://') || text.startsWith('https://'))) {
                    await this.loadImageFromUrl(text);
                    return;
                }
            } catch (error) {
                console.error('Error handling drop:', error);
                alert('Failed to load image. Please try again.');
            }
        },

        async handlePaste(event) {
            if (!this.isFocused) {
                console.log('Paste ignored - card not focused');
                return;
            }
            
            const items = (event.clipboardData || event.originalEvent?.clipboardData)?.items;
            if (!items) return;
            
            console.log('Paste on colourway:', this.colourwayId, 'items:', items.length);
            
            for (let i = 0; i < items.length; i++) {
                const item = items[i];
                
                if (item.kind === 'file' && item.type.startsWith('image/')) {
                    event.preventDefault();
                    const blob = item.getAsFile();
                    if (blob) {
                        console.log('Found pasted image for colourway:', this.colourwayId);
                        const file = new File([blob], `colourway-${this.colourwayId}.png`, { type: blob.type });
                        await this.handleFiles([file]);
                        return;
                    }
                }
                
                if (item.type === 'text/html') {
                    item.getAsString(async (html) => {
                        const imgMatch = html.match(/<img[^>]+src="([^">]+)"/);
                        if (imgMatch && imgMatch[1]) {
                            event.preventDefault();
                            await this.loadImageFromUrl(imgMatch[1]);
                        }
                    });
                }
            }
        },

        async handleFiles(files) {
            if (files.length === 0) return;
            
            const file = files[0];
            if (file.type.startsWith('image/')) {
                this.updateLivewireImage(file);
            }
        },

        async loadImageFromUrl(url) {
            try {
                console.log('Loading image from URL for colourway:', this.colourwayId);
                const response = await fetch(url);
                if (!response.ok) throw new Error('Failed to fetch image');
                
                const blob = await response.blob();
                const filename = `colourway-${this.colourwayId}.jpg`;
                const file = new File([blob], filename, { type: blob.type });
                
                await this.handleFiles([file]);
            } catch (error) {
                console.error('Error loading image from URL:', error);
                alert('Failed to load image from URL.');
            }
        },

        onFileChanged() {
            console.log('File input changed for colourway:', this.colourwayId);
            // Livewire will handle the upload automatically
        },

        updateLivewireImage(file) {
            const dataTransfer = new DataTransfer();
            dataTransfer.items.add(file);
            
            const fileInput = this.$refs.fileInput;
            if (fileInput) {
                fileInput.files = dataTransfer.files;
                fileInput.dispatchEvent(new Event('change', { bubbles: true }));
                fileInput.dispatchEvent(new Event('input', { bubbles: true }));
                console.log('Livewire image updated for colourway:', this.colourwayId);
            }
        }
    }
}
</script>
@endpush