<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.items') }}" class="text-decoration-none">Items</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $item->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Item Details</h1>
            <p class="text-muted mb-0">View and manage item information, specifications, and colourways</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success" x-on:click="updateEditingState(false)">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary" x-on:click="updateEditingState(false)">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary" x-on:click="updateEditingState(true)">
                    <i class="bi bi-pencil me-2"></i>Edit Item
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Two-column layout: Left 1/3 Colourways, Right 2/3 Item Details -->
    <div class="row">
        <!-- Left: Colourways (1/3) -->
        <div class="col-lg-4 order-2 order-lg-2">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="bi bi-palette me-2"></i>Colourways
                    </h6>
                </div>
                <div class="card-body">
                    @if($editing)
                        <div class="mb-3">
                            <div class="mb-3">
                                <label class="form-label small">Import Colour Codes (PDF)</label>
                                <input type="file" wire:model="colourwayPdf" class="form-control form-control-sm @error('colourwayPdf') is-invalid @enderror" accept="application/pdf">
                                @error('colourwayPdf') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                <button type="button" wire:click="processColourwayPdf" class="btn btn-outline-primary btn-sm mt-2">
                                    <i class="bi bi-filetype-pdf me-1"></i> Process PDF
                                </button>
                            </div>
                            <div class="alert alert-info alert-sm mb-3">
                                <i class="bi bi-info-circle me-2"></i>
                                <strong>Quick Upload:</strong> Click the <strong>"Choose or Paste"</strong> button on any colourway to upload an image. Also supports drag & drop and paste (<kbd>Ctrl+V</kbd>/<kbd>⌘V</kbd>)!
                            </div>
                            <input type="text"
                                   wire:model="newColourwayReference"
                                   class="form-control form-control-sm mb-2 @error('newColourwayReference') is-invalid @enderror"
                                   placeholder="Reference">
                            @error('newColourwayReference') <div class="invalid-feedback">{{ $message }}</div> @enderror

                            <input type="file"
                                   wire:model="newColourwayImage"
                                   class="form-control form-control-sm mb-2 @error('newColourwayImage') is-invalid @enderror"
                                   accept="image/*">
                            @error('newColourwayImage') <div class="invalid-feedback">{{ $message }}</div> @enderror

                            @if($newColourwayImage)
                                <div class="mb-2">
                                    <img src="{{ $newColourwayImage->temporaryUrl() }}"
                                         alt="Preview"
                                         class="img-thumbnail"
                                         style="max-width: 60px; max-height: 60px;">
                                </div>
                            @endif

                            <button wire:click="addColourway" class="btn btn-primary btn-sm w-100">
                                <i class="bi bi-plus"></i> Add Colourway
                            </button>
                        </div>
                    @endif

                    @if($item->colourways->count() > 0)
                        <div class="row g-3">
                            @foreach($item->colourways as $colourway)
                                <div class="col-12 col-md-6 col-lg-4 position-relative">
                                    <div class="border rounded p-2 h-100 d-flex flex-column colourway-card"
                                         x-data="colourwayImageHandler({{ $colourway->id }}, {{ $editing ? 'true' : 'false' }})"
                                         @dragover.prevent="handleDragOver"
                                         @dragleave.prevent="handleDragLeave"
                                         @drop.prevent="handleDrop"
                                         @paste.window="handlePaste"
                                         @click="setFocused"
                                         @focus="setFocused"
                                         @blur="removeFocused"
                                         :class="{ 'drag-over': isDragging, 'card-focused': isFocused && isEditing }"
                                         tabindex="0">
                                        <div class="text-center mb-2 position-relative">
                                            @if($colourway->image)
                                                <img src="{{ asset('storage/' . $colourway->image) }}" 
                                                     alt="{{ $colourway->reference }}" 
                                                     class="img-fluid rounded"
                                                     style="height: 130px; object-fit: cover; width: 100%;">
                                                @if($editing)
                                                    <div class="position-absolute top-0 end-0 m-1">
                                                        <button type="button" 
                                                                class="btn btn-sm btn-primary"
                                                                style="width: 32px; height: 32px; padding: 0;"
                                                                @click="$refs.fileInput.click()"
                                                                title="Change image">
                                                            <i class="bi bi-upload"></i>
                                                        </button>
                                                    </div>
                                                @endif
                                            @else
                                                <div class="text-center py-3 bg-light rounded image-placeholder">
                                                    <i class="bi bi-image text-muted fs-2"></i>
                                                    <div class="small text-muted mt-2">No image</div>
                                                    @if($editing)
                                                        <button type="button" 
                                                                class="btn btn-primary btn-sm mt-2"
                                                                @click="$refs.fileInput.click()">
                                                            <i class="bi bi-upload me-1"></i> Choose or Paste
                                                        </button>
                                                        <div class="small text-muted mt-1">Or drag & drop</div>
                                                    @endif
                                                </div>
                                            @endif
                                            <input type="file" 
                                                   x-ref="fileInput" 
                                                   class="d-none" 
                                                   accept="image/*"
                                                   @change="handleFileInput($event)">
                                        </div>

                                        <div class="d-flex align-items-center justify-content-between">
                                            @if($editing)
                                                <input type="text"
                                                       value="{{ $colourway->reference }}"
                                                       wire:blur="updateColourway({{ $colourway->id }}, 'reference', $event.target.value)"
                                                       class="form-control form-control-sm me-2"
                                                       placeholder="Reference">
                                                <button wire:click="removeColourway({{ $colourway->id }})"
                                                        class="btn btn-outline-danger btn-sm"
                                                        style="width: 28px; height: 28px; padding: 0;"
                                                        onclick="return confirm('Delete this colourway?')">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            @else
                                                <div class="text-center w-100">
                                                    <code class="small">{{ $colourway->reference }}</code>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-3">
                            <i class="bi bi-palette fs-1 text-muted"></i>
                            <p class="text-muted small mb-0">No colourways added yet</p>
                            @if($editing)
                                <p class="text-muted small">Add colourways using the form above, or drag & drop images to create them</p>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right: Item Details (2/3) -->
        <div class="col-lg-8 order-1 order-lg-1">
            <!-- Overview -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-tag text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Item Name</label>
                            </div>
                            @if($editing)
                                <input type="text" wire:model="name" class="form-control form-control-sm @error('name') is-invalid @enderror">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fw-medium">{{ $item->name }}</div>
                            @endif
                        </div>
                        
                        <div class="col-md-3">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-currency-dollar text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Price</label>
                            </div>
                            @if($editing)
                                <input type="number" wire:model="price" class="form-control form-control-sm @error('price') is-invalid @enderror" step="0.01" min="0">
                                @error('price') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fw-medium text-primary">{{ $item->formatted_price }}</div>
                            @endif
                    </div>

                        <div class="col-md-3">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-upc text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">SKU</label>
                                </div>
                                @if($editing)
                                <input type="text" wire:model="sku" class="form-control form-control-sm @error('sku') is-invalid @enderror">
                                @error('sku') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <code class="small">{{ $item->sku ?: 'No SKU' }}</code>
                                @endif
                    </div>

                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-tags text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Category</label>
                                </div>
                                @if($editing)
                                <select wire:model="categoriesId" class="form-select form-select-sm @error('categoriesId') is-invalid @enderror">
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('categoriesId') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <span class="badge bg-secondary">{{ $item->category->name }}</span>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar3 text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Season</label>
                                </div>
                                @if($editing)
                                <select wire:model="seasonsId" class="form-select form-select-sm @error('seasonsId') is-invalid @enderror">
                                        <option value="">Select Season</option>
                                        @foreach($seasons as $season)
                                            <option value="{{ $season->id }}">{{ $season->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('seasonsId') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <span class="badge bg-info">{{ $item->season->name }}</span>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-gear text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Status</label>
                            </div>
                            @if($editing)
                                <div class="form-check form-switch">
                                    <input type="checkbox" wire:model="isActive" class="form-check-input" id="isActive">
                                    <label class="form-check-label small" for="isActive">Active</label>
                                </div>
                            @else
                                @if($item->is_active)
                                    <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Active</span>
                                @else
                                    <span class="badge bg-secondary"><i class="bi bi-pause-circle me-1"></i>Inactive</span>
                                @endif
                            @endif
                    </div>

                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-file-text text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">Short Description</label>
                                </div>
                                @if($editing)
                                <input type="text" wire:model="shortDescription" class="form-control form-control-sm @error('shortDescription') is-invalid @enderror" placeholder="Brief description...">
                                @error('shortDescription') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <div class="small text-muted">{{ $item->short_description ?: 'No short description' }}</div>
                                @endif
                            </div>
                            
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-link-45deg text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0 small">URL Slug</label>
                                </div>
                                @if($editing)
                                <input type="text" wire:model="slug" class="form-control form-control-sm @error('slug') is-invalid @enderror">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                <code class="small">{{ $item->slug }}</code>
                                @endif
                    </div>
                </div>
            </div>
        </div>

            <!-- Full Description -->
            @if($item->description || $editing)
            <div class="card mb-4">
                <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="bi bi-file-text me-2"></i>Full Description
                        </h6>
                </div>
                <div class="card-body">
                        @if($editing)
                            <textarea wire:model="description" class="form-control @error('description') is-invalid @enderror" rows="3" placeholder="Detailed item description..."></textarea>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                        @else
                            <div class="text-body">{{ $item->description ?: 'No description provided' }}</div>
                                        @endif
                                    </div>
                                </div>
            @endif

            <!-- Item Images -->
            @if($editing || ($item->images && count($item->images) > 0))
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="bi bi-images me-2"></i>Item Images
                        </h6>
                            </div>
                    <div class="card-body">
                        @if($editing)
                            <div class="upload-area border-2 border-dashed rounded p-3 mb-3"
                                 x-data="itemImageUpload()"
                                 x-init="init()"
                                 @dragover.prevent="handleDragOver"
                                 @dragleave.prevent="handleDragLeave"
                                 @drop.prevent="handleDrop"
                                 @paste.window="handlePaste"
                                 @click="setFocused"
                                 @focus="setFocused"
                                 @blur="removeFocused"
                                 :class="{ 'border-primary bg-light': isDragging, 'card-focused': isFocused }"
                                 tabindex="0">
                                <div class="text-center">
                                    <i class="bi bi-cloud-upload fs-2 text-muted"></i>
                                    <p class="mb-2 small"><strong>Click here</strong>, then press <kbd>Ctrl+V</kbd> to paste</p>
                                    <p class="mb-2 small">Or drag & drop images, or <button type="button" class="btn btn-link btn-sm p-0" @click="$refs.fileInput.click()">browse files</button></p>
                                    <p class="mb-0 small text-muted">Supports images from files, clipboard, or web pages</p>
                                    <input type="file" multiple accept="image/*" class="d-none" x-ref="fileInput" @change="handleFiles($event.target.files)">
                                </div>
                            </div>

                            <div class="row g-2" x-show="images.length > 0">
                                <template x-for="(image, index) in images" :key="index">
                                    <div class="col-md-2 col-4">
                                        <div class="position-relative">
                                            <img :src="image.url" :alt="image.name" class="img-fluid rounded border" style="height: 80px; object-fit: cover; width: 100%;">
                                            <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-1" style="width: 20px; height: 20px; padding: 0;" @click="removeImage(index)">
                                                <i class="bi bi-x" style="font-size: 10px;"></i>
                                            </button>
                        </div>
                                </div>
                                </template>
                            </div>
                        @else
                            @if($item->images && count($item->images) > 0)
                                <div class="row g-2">
                                    @foreach($item->images as $imageUrl)
                                        <div class="col-md-2 col-4">
                                            <img src="{{ $imageUrl }}" alt="{{ $item->name }}" class="img-fluid rounded border" style="height: 80px; object-fit: cover;">
                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-3">
                                    <i class="bi bi-image text-muted"></i>
                                    <p class="text-muted small mb-0">No images uploaded</p>
                            </div>
                            @endif
                        @endif
                    </div>
                </div>
            @endif

            <!-- Specifications -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="bi bi-list-ul me-2"></i>Specifications
                    </h6>
                </div>
                <div class="card-body">
                    @if($editing)
                        <div class="row g-2 mb-3">
                    <div class="col-md-4">
                                <input type="text" wire:model="newSpecName" class="form-control form-control-sm" placeholder="Spec name (e.g., Material)">
                    </div>
                    <div class="col-md-6">
                                <input type="text" wire:model="newSpecValue" class="form-control form-control-sm" placeholder="Value (e.g., 100% Cotton)">
                    </div>
                            <div class="col-md-2">
                                <button wire:click="addSpecification" class="btn btn-primary btn-sm w-100">
                                    <i class="bi bi-plus"></i> Add
                        </button>
                    </div>
                </div>
            @endif

                    @if(is_array($specifications) && count($specifications) > 0)
                        <div class="row g-2">
                    @foreach($specifications as $index => $spec)
                                @if(is_array($spec) && isset($spec['name']) && isset($spec['value']))
                        <div class="col-md-6">
                                        <div class="border rounded p-2">
                                            @if($editing)
                                                <div class="row g-1">
                                                    <div class="col-5">
                                                        <input type="text" wire:model="specifications.{{ $index }}.name" class="form-control form-control-sm">
                                                    </div>
                                                    <div class="col-5">
                                                        <input type="text" wire:model="specifications.{{ $index }}.value" class="form-control form-control-sm">
                                                    </div>
                                                    <div class="col-2">
                                                        <button wire:click="removeSpecification({{ $index }})" class="btn btn-outline-danger btn-sm w-100">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <div class="fw-semibold small">{{ $spec['name'] }}</div>
                                                        <div class="text-muted" style="font-size: 0.8rem;">{{ $spec['value'] }}</div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                                        </div>
                                                    @endif
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="text-center py-3">
                            <i class="bi bi-list-ul fs-1 text-muted"></i>
                            <p class="text-muted small mb-0">No specifications added yet</p>
                        </div>
                    @endif
                </div>
                </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.colourway-card {
    transition: all 0.2s ease;
    cursor: pointer;
    outline: none;
}

.colourway-card.drag-over {
    border-color: #0d6efd !important;
    background-color: rgba(13, 110, 253, 0.1) !important;
    transform: scale(1.02);
}

.colourway-card.card-focused {
    border-color: #0d6efd !important;
    background-color: rgba(13, 110, 253, 0.05) !important;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}

.colourway-card.card-focused::after {
    content: "Ready to paste! Press Ctrl+V (⌘V on Mac)";
    position: absolute;
    top: -30px;
    left: 50%;
    transform: translateX(-50%);
    background: #0d6efd;
    color: white;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 11px;
    white-space: nowrap;
    z-index: 1000;
    pointer-events: none;
}

.image-placeholder {
    transition: all 0.2s ease;
}

.colourway-card:hover .image-placeholder {
    background-color: rgba(13, 110, 253, 0.05);
}

/* For the item upload area */
.upload-area.card-focused {
    border-color: #0d6efd !important;
    background-color: rgba(13, 110, 253, 0.05) !important;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}
</style>
@endpush

@push('scripts')
<script>
/**
 * Alpine.js component for handling colourway image drag, drop, and paste
 * Supports:
 * - Drag and drop from file system
 * - Drag and drop from web pages (images)
 * - Clipboard paste (Ctrl+V / Cmd+V)
 * - Right-click paste
 */
function colourwayImageHandler(colourwayId, isEditing) {
    return {
        colourwayId: colourwayId,
        isEditing: isEditing,
        isDragging: false,
        isFocused: false,

        setFocused() {
            if (!this.isEditing) return;
            this.isFocused = true;
        },

        removeFocused() {
            if (!this.isEditing) return;
            // Small delay to allow paste event to fire first
            setTimeout(() => {
                this.isFocused = false;
            }, 100);
        },

        handleDragOver(event) {
            if (!this.isEditing) return;
            this.isDragging = true;
        },

        handleDragLeave(event) {
            if (!this.isEditing) return;
            // Only remove drag state if we're leaving the element entirely
            if (!event.currentTarget.contains(event.relatedTarget)) {
                this.isDragging = false;
            }
        },

        async handleDrop(event) {
            if (!this.isEditing) return;
            
            this.isDragging = false;
            
            try {
                // Handle file drops
                if (event.dataTransfer.files && event.dataTransfer.files.length > 0) {
                    const file = event.dataTransfer.files[0];
                    if (file.type.startsWith('image/')) {
                        await this.uploadImage(file);
                        return;
                    }
                }
                
                // Handle image drag from web pages (get URL)
                const html = event.dataTransfer.getData('text/html');
                const text = event.dataTransfer.getData('text/plain');
                
                // Try to extract image URL from HTML
                if (html) {
                    const imgMatch = html.match(/<img[^>]+src="([^">]+)"/);
                    if (imgMatch && imgMatch[1]) {
                        await this.loadImageFromUrl(imgMatch[1]);
                        return;
                    }
                }
                
                // Try direct URL
                if (text && (text.startsWith('http://') || text.startsWith('https://'))) {
                    await this.loadImageFromUrl(text);
                    return;
                }
                
            } catch (error) {
                console.error('Error handling drop:', error);
                alert('Failed to load image. Please try again.');
            }
        },

        handlePaste(event) {
            if (!this.isEditing) return;
            
            // Only handle paste if this colourway is focused or if the paste came from within this element
            const targetInThisCard = event.target.closest('.colourway-card') === this.$el;
            if (!targetInThisCard && !this.isFocused) return;
            
            const items = event.clipboardData?.items;
            if (!items) return;
            
            // Look for images in clipboard
            for (let i = 0; i < items.length; i++) {
                const item = items[i];
                
                // Handle image files
                if (item.type.startsWith('image/')) {
                    event.preventDefault();
                    const file = item.getAsFile();
                    if (file) {
                        this.uploadImage(file);
                        return;
                    }
                }
                
                // Handle HTML content with images
                if (item.type === 'text/html') {
                    item.getAsString((html) => {
                        const imgMatch = html.match(/<img[^>]+src="([^">]+)"/);
                        if (imgMatch && imgMatch[1]) {
                            event.preventDefault();
                            this.loadImageFromUrl(imgMatch[1]);
                        }
                    });
                }
            }
        },


        handleFileInput(event) {
            const file = event.target.files[0];
            if (file && file.type.startsWith('image/')) {
                this.uploadImage(file);
            }
            // Reset the input so the same file can be selected again
            event.target.value = '';
        },

        async uploadImage(file) {
            console.log('Uploading image for colourway:', this.colourwayId, file);
            
            return new Promise((resolve, reject) => {
                @this.upload('tempColourwayImage', file, 
                    // Success callback
                    () => {
                        @this.call('uploadColourwayImage', this.colourwayId).then(resolve);
                    },
                    // Error callback
                    (error) => {
                        console.error('Upload error:', error);
                        alert('Failed to upload image. Please try again.');
                        reject(error);
                    },
                    // Progress callback
                    (event) => {
                        // Could show progress indicator here
                        console.log('Upload progress:', event.detail.progress + '%');
                    }
                );
            });
        },

        async loadImageFromUrl(url) {
            try {
                console.log('Loading image from URL:', url);
                
                // Fetch the image
                const response = await fetch(url);
                if (!response.ok) throw new Error('Failed to fetch image');
                
                const blob = await response.blob();
                
                // Convert to File object
                const filename = url.split('/').pop().split('?')[0] || 'image.jpg';
                const file = new File([blob], filename, { type: blob.type });
                
                await this.uploadImage(file);
            } catch (error) {
                console.error('Error loading image from URL:', error);
                alert('Failed to load image from URL. The image may be protected or unavailable.');
            }
        }
    }
}

/**
 * Alpine.js component for handling item image uploads
 * Supports multiple images via drag, drop, paste, and file selection
 */
function itemImageUpload() {
    return {
        isDragging: false,
        isFocused: false,
        images: [],

        init() {
            this.images = @json($item->images ?? []).map((url, index) => ({
                name: `image-${index}`,
                url: url,
                isExisting: true
            }));
        },

        setFocused() {
            this.isFocused = true;
        },

        removeFocused() {
            // Small delay to allow paste event to fire first
            setTimeout(() => {
                this.isFocused = false;
            }, 100);
        },

        handleDragOver(event) {
            this.isDragging = true;
        },

        handleDragLeave(event) {
            if (!event.currentTarget.contains(event.relatedTarget)) {
                this.isDragging = false;
            }
        },

        async handleDrop(event) {
            this.isDragging = false;
            
            try {
                // Handle file drops
                if (event.dataTransfer.files && event.dataTransfer.files.length > 0) {
                    await this.handleFiles(event.dataTransfer.files);
                    return;
                }
                
                // Handle image drag from web pages
                const html = event.dataTransfer.getData('text/html');
                const text = event.dataTransfer.getData('text/plain');
                
                if (html) {
                    const imgMatch = html.match(/<img[^>]+src="([^">]+)"/);
                    if (imgMatch && imgMatch[1]) {
                        await this.loadImageFromUrl(imgMatch[1]);
                        return;
                    }
                }
                
                if (text && (text.startsWith('http://') || text.startsWith('https://'))) {
                    await this.loadImageFromUrl(text);
                    return;
                }
                
            } catch (error) {
                console.error('Error handling drop:', error);
                alert('Failed to load image. Please try again.');
            }
        },

        async handlePaste(event) {
            // Only handle paste if this area is focused
            if (!this.isFocused) return;
            
            const items = event.clipboardData?.items;
            if (!items) return;
            
            let handled = false;
            
            for (let i = 0; i < items.length; i++) {
                const item = items[i];
                
                if (item.type.startsWith('image/')) {
                    event.preventDefault();
                    handled = true;
                    const file = item.getAsFile();
                    if (file) {
                        await this.handleFiles([file]);
                    }
                }
                
                if (item.type === 'text/html') {
                    item.getAsString(async (html) => {
                        const imgMatch = html.match(/<img[^>]+src="([^">]+)"/);
                        if (imgMatch && imgMatch[1]) {
                            event.preventDefault();
                            await this.loadImageFromUrl(imgMatch[1]);
                        }
                    });
                }
            }
        },

        async handleFiles(files) {
            const fileArray = Array.from(files);
            
            for (const file of fileArray) {
                if (file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    
                    await new Promise((resolve) => {
                    reader.onload = (e) => {
                            this.images.push({ 
                                name: file.name, 
                                url: e.target.result, 
                                file: file,
                                isExisting: false
                            });
                            resolve();
                    };
                    reader.readAsDataURL(file);
                    });
                }
            }
            
            this.updateLivewireImages();
        },

        async loadImageFromUrl(url) {
            try {
                console.log('Loading image from URL:', url);
                
                const response = await fetch(url);
                if (!response.ok) throw new Error('Failed to fetch image');
                
                const blob = await response.blob();
                const filename = url.split('/').pop().split('?')[0] || 'image.jpg';
                const file = new File([blob], filename, { type: blob.type });
                
                await this.handleFiles([file]);
            } catch (error) {
                console.error('Error loading image from URL:', error);
                alert('Failed to load image from URL. The image may be protected or unavailable.');
            }
        },

        removeImage(index) {
            this.images.splice(index, 1);
            this.updateLivewireImages();
        },

        updateLivewireImages() {
            const imageUrls = this.images.map(img => img.url);
            @this.set('images', imageUrls);
        }
    }
}

// Update editing state when buttons are clicked
function updateEditingState(editing) {
    console.log('Editing state updated:', editing);
}
</script>
@endpush