<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TransactionMatch extends Model
{
    protected $fillable = [
        'statement_transaction_id',
        'receipt_id',
        'matched_amount',
        'match_method',
        'amount_confidence',
        'date_confidence',
        'merchant_confidence',
        'explanation',
    ];

    public function statementTransaction(): BelongsTo
    {
        return $this->belongsTo(StatementTransaction::class);
    }

    public function receipt(): BelongsTo
    {
        return $this->belongsTo(Receipt::class);
    }
}
