<?php

namespace App\Models;

use Laravel\Jetstream\HasTeams;
use Laravel\Sanctum\HasApiTokens;
use OwenIt\Auditing\Models\Audit;
use Laravel\Jetstream\HasProfilePhoto;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

/**
 * User model representing application users.
 * 
 * @package App\Models
 */
class User extends Authenticatable
{
    use HasFactory;
    use SoftDeletes;
    use HasApiTokens;
    use HasProfilePhoto;
    use HasTeams;
    use Notifiable;
    use TwoFactorAuthenticatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'current_team_id',
        'deleted_at',
        'email',
        'email_verified_at',
        'name',
        'password',
        'phone',
        'profile_photo_path',
        'remember_token',
        'settings',
        'two_factor_confirmed_at',
        'two_factor_recovery_codes',
        'two_factor_secret',
        'zoho_refresh_token',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_recovery_codes',
        'two_factor_secret',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
        'email_verified_at' => 'datetime',
        'settings' => 'array',
        'updated_at' => 'datetime:Y-m-d',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array<int, string>
     */
    protected $appends = [
        'profile_photo_url',
    ];

    public function getLatestChangeAttribute(){
        // dd(Audit::where('user_id', $this->id)->latest()->pluck('created_at')->first());
        // return Audit::where('user_id', $this->id)->latest()->first()->pluck('created_at');
    }

    public function latestAudit()
    {
        return $this->hasOne(Audit::class)->latestOfMany();
    }


    public function teams()
    {
        return $this->belongsToMany(Team::class)->withPivot('role'); // 👈 important
    }


    /**
     * Retrieve a setting with a given name or fall back to the default.
     *
     */
    public function setting(string $name, $default = null)
    {
        if ($this->settings != NULL && array_key_exists($name, $this->settings)) {
            return $this->settings[$name];
        }
        return $default;
    }

    /**
     * Update one or more settings and then optionally save the model.
     *
     */
    public function settings(array $revisions, bool $save = true) : self
    {
        if($this->settings != NULL)
            $this->settings = array_merge($this->settings, $revisions);
        else
            $this->settings = $revisions;
        if ($save) {
            $this->save();
        }
        return $this;
    }

    public function user_departments()
    {
        return $this->hasMany(UserDepartment::class, 'users_id');
    }
}
