{{-- shipment-schedule-dev.blade.php --}}
<div id="page-content">
    {{-- Title Bar --}}
    <x-title-bar>
        <x-slot:title>
            Wholesale Shipment Schedule
        </x-slot:title>
        <x-slot:end>
            {{-- Save Indicators --}}
            <button id="saved" class="btn btn-success" style="display: none">Saved</button>
            <button id="saving" class="btn btn-danger" style="display: none">Saving Changes...</button>

            @can('finance:update')
                {{-- Invoice Button --}}
                <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'invoices'})">Invoice</button>
            @endcan

            {{-- Other Actions --}}
            <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'totals'})" wire:click="$dispatch('calcTotals')">Page Totals</button>
            <button class="btn btn-light" wire:click.prevent="$toggle('borders')">Borders</button>
            <a class="btn btn-light" wire:click="selectAll" @if($this->hasMorePages()) onclick="confirm('This will select every item matching the filters, even if they are not yet loaded on this page. Continue?') || event.stopImmediatePropagation()" @endif>Select All</a>
            <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'edit-ss'})" wire:click="edit">Edit Selected</button>
        </x-slot:end>
        <x-slot:sub>
            {{-- Filters --}}
                <div class="row mt-2 mx-1">
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="view">
                                <option value="">All Shipments</option>
                                <option value="unshipped">Unshipped</option>
                                <option value="financeNC">Finance Not Complete</option>
                                <option value="noRTInvoice">Not Invoiced Out</option>
                                <option value="cashflow">Cashflow</option>
                            </select>
                            <label>View</label>
                        </div>
                    </div>
                    @if(empty($this->view))
                        <div class="col-xl-2 col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="fromDate">
                                <label>From</label>
                            </div>
                        </div>
                    @endif
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="toDate">
                            <label>To</label>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showSeasonDropdown') }">
                            <button class="btn w-100 border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">
                                <i class="fas fa-calendar-alt me-1"></i>Seasons @if(empty($season)) (All) @else() ({{count($season)}}) @endif
                            </button>
                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('season')">All</button>
                                </li>
                                @foreach($this->seasons as $i=>$c)
                                    <li class="px-3 py-1 @if($season[$c->id] ?? 0) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('season', {{$c->id}})">{{ $c->description }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showCustomerDropdown') }">
                            <button class="btn w-100 border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">
                                <i class="fas fa-users me-1"></i>Customers @if(empty($customer)) (All) @else() ({{count($customer)}}) @endif
                            </button>
                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('customer')">All</button>
                                </li>
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="$toggle('hideMabli')">@if(!$hideMabli)Hide @else Show @endif Mabli</button>
                                </li>
                                @foreach($this->customers as $i=>$c)
                                    <li class="px-3 py-1 @if($customer[$c->id] ?? 0) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('customer', {{$c->id}})">{{ $c->name }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showFactoryDropdown') }">
                            <button class="btn w-100 border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">
                                <i class="fas fa-industry me-1"></i>Factories @if(empty($factory)) (All) @else() ({{count($factory)}}) @endif
                            </button>
                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('factory')">All</button>
                                </li>
                                @foreach($this->factories as $i=>$c)
                                    <li class="px-3 py-1 @if($factory[$c->id] ?? 0) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('factory', {{$c->id}})">{{ $c->name }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row mx-1">
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showCooDropdown') }">
                            <button class="btn w-100 border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">
                                <i class="fas fa-flag me-1"></i>COO @if(empty($coo)) (All) @else() ({{count($coo)}}) @endif
                            </button>
                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('coo')">All</button>
                                </li>
                                @foreach($this->factories->unique('countries_id') as $i=>$c)
                                    <li class="px-3 py-1 @if($coo[$c->countries->id] ?? 0) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('coo', {{$c->countries->id}})">{{ $c->countries->country }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showTruckDropdown') }">
                            <button class="btn w-100 border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">
                                <i class="fas fa-building me-1"></i>Dept @if(empty($department)) (All) @else() ({{count($department)}}) @endif
                            </button>
                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('department')">All</button>
                                </li>
                                @foreach($this->departments as $i=>$c)
                                    <li class="px-3 py-1 @if($department[$c->id] ?? 0) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('department', {{$c->id}})">{{ $c->description }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showCatDropdown') }">
                            <button class="btn w-100 border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">
                                <i class="fas fa-tags me-1"></i>Category @if(empty($category)) (All) @else() ({{count($category)}}) @endif
                            </button>
                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('category')">All</button>
                                </li>
                                <li class="px-3 py-1 @if($category['mens'] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('category', 'mens')">Mens</span><br>
                                </li>
                                <li class="px-3 py-1 @if($category['ladies'] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('category', 'ladies')">Ladies</span><br>
                                </li>
                                <li class="px-3 py-1 @if($category['childrens'] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('category', 'childrens')">Childrens</span><br>
                                </li>
                                <li class="px-3 py-1 @if($category['accessories'] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('category', 'accessories')">Accessories</span><br>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Truck Number" class="form-control" wire:model.live.debounce.500ms="truck">
                            <label>Truck</label>
                            <div class="invalid-feedback">@error('truck') {{ $message }} @enderror</div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Search..." class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                    </div>
                </div>
                <div class="row mx-1">
                    <div class="col-xl-12 col-12 mb-2 px-1">
                        <button class="btn w-100 btn-outline-primary bg-white" style="height: calc(3.5rem + 2px);" type="button" wire:click="clearFilters">
                            <i class="fas fa-eraser me-2"></i>Clear All Filters
                        </button>
                    </div>
                </div>
        </x-slot:sub>
    </x-title-bar>

    {{-- Main Content --}}
    <div id="page-content-container" class="container-fluid">
        {{-- Alert Messages --}}
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert alert-dark" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        {{-- Data Table --}}
        <div class="row">
            <div class="col">
                <form method="POST" id="ss-form">
                    @csrf
                    <table id="tableSort" class="mt-2 table rounded @if($borders) table-bordered @endif">
                        <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                            <tr class="border">
                                                                            <th class="box-shaddow-border-y-2 text-center">Drop#</th>
                                @if($this->columns['Season'])				<th class="box-shaddow-border-y-2 text-center">Season</th>					                        @endif
                                @if($this->columns['Factory'])				<th class="box-shaddow-border-y-2 text-center">Factory</th>				                        @endif
                                @if($this->columns['Customer'])				<th class="box-shaddow-border-y-2 text-center">Customer</th>				                        @endif
                                {{-- @if($this->columns['Order Issued'])			<th class="box-shaddow-border-y-2 text-center">Order Issued</th>			                        @endif --}}
                                @if($this->columns['Order No'])				<th class="box-shaddow-border-y-2 text-center">Order No</th>				                        @endif
                                @if($this->columns['Style'])				<th class="box-shaddow-border-y-2 text-center">Style</th>					                        @endif
                                @if($this->columns['Description'])			<th class="box-shaddow-border-y-2 text-center">Description</th>			                        @endif
                                @if($this->columns['Colour'])				<th class="box-shaddow-border-y-2 text-center">Colour</th>					                        @endif
                                @if($this->columns['Image'])				<th class="box-shaddow-border-y-2 text-center">Image</th>					                        @endif
                                @if($this->columns['Sizes'])				<th class="box-shaddow-border-y-2 text-center">Sizes</th>					                        @endif
                                @if($this->columns['Total Qty'])			<th class="box-shaddow-border-y-2 text-center">Total Qty</th>				                        @endif
                                @if($this->columns['Total Shipped'])		<th class="box-shaddow-border-y-2 text-center" style="min-width: 80px;">Total Shipped</th>			                        @endif
                                @if($this->columns['Sealer Sample'])		<th class="box-shaddow-border-y-2 text-center" style="min-width: 130px;">Sealer Sample</th>		@endif
                                @if($this->columns['Shipment Sample'])		<th class="box-shaddow-border-y-2 text-center" style="min-width: 130px;">Shipment Sample</th>		@endif
                                @if($this->columns['ExFty'])				<th class="box-shaddow-border-y-2 text-center">ExFty</th>					                        @endif
                                @if($this->columns['Revised ExFty'])		<th class="box-shaddow-border-y-2 text-center">Revised ExFty</th>			                        @endif
                                @if($this->columns['Customer exFty'])		<th class="box-shaddow-border-y-2 text-center">Customer exFty</th>			                        @endif
                                @if($this->columns['Customer Into w/h'])	<th class="box-shaddow-border-y-2 text-center">Customer Into w/h</th>		                        @endif
                                {{-- @if($this->columns['CMT'])					<th class="box-shaddow-border-y-2 text-center">CMT</th>					                        @endif --}}
                                @if($this->columns['Total CMT'])			<th class="box-shaddow-border-y-2 text-center">Total Cost</th>				                        @endif
                                {{-- @if($this->columns['Quote'])				<th class="box-shaddow-border-y-2 text-center">Quote</th>					                        @endif --}}
                                @if($this->columns['Total Sale'])			<th class="box-shaddow-border-y-2 text-center">Total Sale</th>				                        @endif
                                @if($this->columns['Transport Budget'])		<th class="box-shaddow-border-y-2 text-center">Transport Budget</th>		                        @endif
                                @if($this->columns['Incoterms'])			<th class="box-shaddow-border-y-2 text-center">Incoterms</th>				                        @endif
                                @if($this->columns['Truck'])				<th class="box-shaddow-border-y-2 text-center">Truck</th>					                        @endif
                                @if($this->columns['Collection'])			<th class="box-shaddow-border-y-2 text-center">Collection</th>				                        @endif
                                @if($this->columns['Customs ERN'])			<th class="box-shaddow-border-y-2 text-center">Customs ERN</th>			                        @endif
                                @if($this->columns['Shipped'])				<th class="box-shaddow-border-y-2 text-center">Shipped</th>				                        @endif
                                @if($this->columns['RT Invoice'])			<th class="box-shaddow-border-y-2 text-center">Invoices</th>				                        @endif
                                @if($this->columns['RT Invoice'])			<th class="box-shaddow-border-y-2 text-center">Finance Notes</th>				                        @endif
                            </tr>
                        </thead>
                        @if(!empty($chunks))
                            @foreach (array_slice($chunks, 0, $page) as $chunk)
                                <livewire:production.reports.shipment-schedule-row
                                    :columns="$columns"
                                    :chunk="$chunk"
                                    :selected="$selected"
                                    :key="'chunk-' . md5(json_encode($chunk)) . '-' . $refreshKey"
                                />
                            @endforeach
                        @endif
                        <tr>
                            <td colspan="100%">
                                @if ($this->hasMorePages())
                                    <div x-data="{ loading: false }"
                                        x-intersect="loading = true; $wire.loadMore().then(() => loading = false)"
                                        class="text-center mt-3 w-100"
                                        style="transform: translateY(-80vh);">
                                    </div>
                                    <div class="text-center mt-3 p-5">
                                        <div class="text-4 mt-2 h4 fst-italic">Loading more records...</div>
                                    </div>
                                @endif
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>

    <x-modal name="edit-style" title="Edit Style">
		<x-slot:body>
				<livewire:development.styles.style-edit wire:key='editStyle' />
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-order" title="Edit Order" size="modal-fullscreen">
		<x-slot:body>
            @can('order:create')
			    <livewire:sales.orders.orders-edit wire:key="orderEdit" />
            @endcan
		</x-slot:body>
	</x-modal>
	<x-modal name="edit-ss" title="Bulk Edit Drops" size="modal-lg">
		<x-slot:body>
				<livewire:production.reports.shipment-schedule-edit wire:key='editBulk' />
		</x-slot:body>
	</x-modal>
	<x-modal name="view-audit-log" title="Audit Log" size="modal-lg">
		<x-slot:body>
				<livewire:view-audit-log wire:key='auditLog' />
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-sample" title="Edit Sample" size="modal-lg">
        <x-slot:body>
                <livewire:development.samples.samples-edit wire:key="sampleEdit" />
        </x-slot:body>
    </x-modal>
    <x-modal name="edit-shipment" title="Edit Shipment">
		<x-slot:body>
			<livewire:production.shipments.shipments-edit wire:key="shipmentEdit" />
		</x-slot:body>
	</x-modal>

    <x-modal name="totals" title="Page Totals" size="modal-sm">
		<x-slot:body>
            <div class="modal-body">
                <livewire:production.reports.shipment-schedule-totals :chunks="$chunks" :key="$refreshKey" />
            </div>
		</x-slot:body>
	</x-modal>

    <x-modal name="invoices" title="Invoices" size="modal-sm">
        <x-slot:body>
            <livewire:zoho.zoho-invoice-manager :selectedDrops="array_keys($selected)" />
        </x-slot:body>
    </x-modal>

    <x-modal name="split-drop" title="Split Drop" size="modal-lg">
        <x-slot:body>
            <livewire:production.reports.shipment-schedule-split-drop wire:key="splitDrop" lazy />
        </x-slot:body>
    </x-modal>


    {{-- Footer --}}
    {{-- <x-footer>
        <x-slot:center>
            {{ $drops->links() }}
        </x-slot:center>
    </x-footer> --}}

    <script>
        function calculateTotalOrdered(dropId) {
            console.log('calcd');
            let total = 0;
            const inputs = document.querySelectorAll(`input[id^='qty_${dropId}_']`);
            inputs.forEach(input => {
                total += parseInt(input.value) || 0;
            });
            return total;
        }
        function calculateTotalShipped(dropId) {
            let total = 0;
            const inputs = document.querySelectorAll(`input[id^='shipped_${dropId}_']`);
            inputs.forEach(input => {
                total += parseInt(input.value) || 0;
            });
            return total;
        }
    </script>
<script>
document.addEventListener("alpine:init", () => {
    Alpine.data("shipmentHandler", (dropId, initialValue) => ({
        fieldValue: initialValue, // Set the initial value from the Blade template

        handlePaste(event, dropId) {
    console.log('Paste handler called for dropId:', dropId);
    event.preventDefault(); // Prevent default paste behavior

    let clipboardData = event.clipboardData || window.clipboardData;
    let pastedValues = clipboardData.getData("text").split("\t").map(val => val.trim()).filter(val => val !== "");
    console.log('Pasted values:', pastedValues);

    // Get all inputs matching this drop ID
    let inputs = document.querySelectorAll(`input[id^="shipped_qty_${dropId}_"]`);
    console.log('Found inputs:', inputs.length);

    inputs.forEach((input, index) => {
        if (pastedValues[index] !== undefined) {
            let newValue = pastedValues[index];
            console.log(`Updating input ${index} with value:`, newValue);

            // Update input visually
            input.value = newValue;

            // Dispatch event to update Alpine's reactivity
            input.dispatchEvent(new Event("input", { bubbles: true }));

            // Extract size ID from the input ID (same as regular change handler)
            let sizeId = input.id.split("_").pop(); // Gets the last part of the ID (which should be `size_id`)
            console.log('Size ID:', sizeId, 'Value:', newValue);

            // Try to find the specific row component and dispatch to it
            let rowComponent = input.closest('[wire\\:id]');
            if (rowComponent) {
                let componentId = rowComponent.getAttribute('wire:id');
                console.log('Found row component ID:', componentId);
                
                // Dispatch to the specific row component
                Livewire.dispatch('updateShippedQty', { sizeId: parseInt(sizeId), value: newValue }, componentId);
                console.log('Dispatched updateShippedQty event to row component with sizeId:', parseInt(sizeId));
            } else {
                // Fallback to global dispatch
                Livewire.dispatch('updateShippedQty', { sizeId: parseInt(sizeId), value: newValue });
                console.log('Dispatched updateShippedQty event globally with sizeId:', parseInt(sizeId));
            }
        }
    });
}
    }));
});
    </script>

<style>
/* Remove all borders from table rows and cells */
#tableSort tbody tr {
    border-top: none !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

#tableSort tbody td {
    border-top: none !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

/* Override any inline styles that add borders */
#tableSort tbody tr[style*="border"] {
    border-top: none !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

.cursor-pointer {
    cursor: pointer;
}

.exfty-history-compact {
    text-align: left;
    padding: 2px;
}

.exfty-history-item {
    font-size: 0.8em;
    line-height: 1.1;
    padding: 1px 0;
    margin: 0;
    color: #6c757d;
    white-space: nowrap;
}

.exfty-history-item.current {
    font-weight: bold;
    color: #28a745;
}

.exfty-arrow {
    text-align: center;
    font-size: 0.7em;
    color: #6c757d;
    padding: 1px 0;
    margin: 0;
    line-height: 1;
}
</style>

</div>
