<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->json('wellness_goals')->nullable(); // Array of wellness goals
            $table->string('voice_preference')->default('female'); // female, male, neutral
            $table->string('sensitivity_level')->default('standard'); // low, standard, high
            $table->text('medical_notes')->nullable(); // For safety considerations
            $table->json('preferences')->nullable(); // General user preferences
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('profiles');
    }
};
