<?php

namespace App\Services\Safety;

use App\DTO\SafetyDecision;
use App\Services\Contracts\SafetyService;

class SimpleSafetyService implements SafetyService
{
    public function check(string $text, string $context): SafetyDecision
    {
        if (!config('safety.feature_flags.safety_checks_enabled')) {
            return new SafetyDecision('allow', $text);
        }

        $lower = mb_strtolower($text);
        foreach (config('safety.blocklist_phrases', []) as $phrase) {
            if (str_contains($lower, mb_strtolower($phrase))) {
                return new SafetyDecision('block', null, ['blocked_phrase' => $phrase]);
            }
        }
        return new SafetyDecision('allow', $text);
    }
}


